/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.camel.endpoint;

import com.consol.citrus.camel.endpoint.CamelEndpointConfiguration;
import com.consol.citrus.context.TestContext;
import com.consol.citrus.exceptions.ActionTimeoutException;
import com.consol.citrus.message.Message;
import com.consol.citrus.messaging.Consumer;
import org.apache.camel.ConsumerTemplate;
import org.apache.camel.Exchange;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CamelConsumer
implements Consumer {
    private final CamelEndpointConfiguration endpointConfiguration;
    private final String name;
    private ConsumerTemplate consumerTemplate;
    private static Logger log = LoggerFactory.getLogger(CamelConsumer.class);

    public CamelConsumer(String name, CamelEndpointConfiguration endpointConfiguration) {
        this.name = name;
        this.endpointConfiguration = endpointConfiguration;
    }

    public Message receive(TestContext context) {
        return this.receive(context, this.endpointConfiguration.getTimeout());
    }

    public Message receive(TestContext context, long timeout) {
        Exchange exchange;
        if (log.isDebugEnabled()) {
            log.debug("Receiving message from camel endpoint: '" + this.endpointConfiguration.getEndpointUri() + "'");
        }
        if ((exchange = this.getConsumerTemplate().receive(this.endpointConfiguration.getEndpointUri(), timeout)) == null) {
            throw new ActionTimeoutException("Action timed out while receiving message from camel endpoint '" + this.endpointConfiguration.getEndpointUri() + "'");
        }
        log.info("Received message from camel endpoint: '" + this.endpointConfiguration.getEndpointUri() + "'");
        Message message = this.endpointConfiguration.getMessageConverter().convertInbound(exchange, this.endpointConfiguration, context);
        context.onInboundMessage(message);
        return message;
    }

    protected ConsumerTemplate getConsumerTemplate() {
        if (this.consumerTemplate == null) {
            this.consumerTemplate = this.endpointConfiguration.getCamelContext().createConsumerTemplate();
        }
        return this.consumerTemplate;
    }

    public String getName() {
        return this.name;
    }
}

