/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.camel.endpoint;

import com.consol.citrus.camel.endpoint.CamelEndpoint;
import com.consol.citrus.camel.endpoint.CamelEndpointConfiguration;
import com.consol.citrus.camel.endpoint.CamelSyncEndpoint;
import com.consol.citrus.camel.endpoint.CamelSyncEndpointConfiguration;
import com.consol.citrus.context.TestContext;
import com.consol.citrus.endpoint.AbstractEndpointComponent;
import com.consol.citrus.endpoint.Endpoint;
import com.consol.citrus.endpoint.EndpointConfiguration;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.impl.DefaultCamelContext;

public class CamelEndpointComponent
extends AbstractEndpointComponent {
    protected Endpoint createEndpoint(String resourcePath, Map<String, String> parameters, TestContext context) {
        CamelEndpoint endpoint;
        if (resourcePath.startsWith("sync:")) {
            endpoint = new CamelSyncEndpoint();
            endpoint.getEndpointConfiguration().setEndpointUri(resourcePath.substring("sync:".length()) + this.getParameterString(parameters, CamelSyncEndpointConfiguration.class));
        } else {
            endpoint = new CamelEndpoint();
            endpoint.getEndpointConfiguration().setEndpointUri(resourcePath + this.getParameterString(parameters, CamelEndpointConfiguration.class));
        }
        if (context.getReferenceResolver() != null) {
            if (context.getReferenceResolver().resolveAll(CamelContext.class).size() == 1) {
                endpoint.getEndpointConfiguration().setCamelContext((CamelContext)context.getReferenceResolver().resolve(CamelContext.class));
            } else if (context.getReferenceResolver().isResolvable("camelContext")) {
                endpoint.getEndpointConfiguration().setCamelContext((CamelContext)context.getReferenceResolver().resolve("camelContext", CamelContext.class));
            } else {
                endpoint.getEndpointConfiguration().setCamelContext((CamelContext)new DefaultCamelContext());
            }
        }
        this.enrichEndpointConfiguration((EndpointConfiguration)endpoint.getEndpointConfiguration(), this.getEndpointConfigurationParameters(parameters, ((Object)((Object)endpoint.getEndpointConfiguration())).getClass()), context);
        return endpoint;
    }
}

