/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.camel.actions;

import com.consol.citrus.camel.actions.AbstractCamelRouteAction;
import com.consol.citrus.context.TestContext;
import com.consol.citrus.exceptions.CitrusRuntimeException;
import org.apache.camel.impl.engine.AbstractCamelContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StopCamelRouteAction
extends AbstractCamelRouteAction {
    private static Logger log = LoggerFactory.getLogger(StopCamelRouteAction.class);

    public StopCamelRouteAction(Builder builder) {
        super("stop-routes", builder);
    }

    public void doExecute(TestContext context) {
        for (String routeId : this.routeIds) {
            String route = context.replaceDynamicContentInString(routeId);
            try {
                ((AbstractCamelContext)this.camelContext).stopRoute(route);
                log.info(String.format("Stopped Camel route '%s' on context '%s'", route, this.camelContext.getName()));
            }
            catch (Exception e) {
                throw new CitrusRuntimeException("Failed to stop Camel route: " + route, (Throwable)e);
            }
        }
    }

    public static final class Builder
    extends AbstractCamelRouteAction.Builder<StopCamelRouteAction, Builder> {
        public StopCamelRouteAction build() {
            return new StopCamelRouteAction(this);
        }
    }
}

