/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.camel.endpoint;

import com.consol.citrus.camel.endpoint.CamelEndpointConfiguration;
import com.consol.citrus.context.TestContext;
import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.message.Message;
import com.consol.citrus.messaging.Producer;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.ProducerTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CamelProducer
implements Producer {
    private final String name;
    private final CamelEndpointConfiguration endpointConfiguration;
    private ProducerTemplate producerTemplate;
    private static Logger log = LoggerFactory.getLogger(CamelProducer.class);

    public CamelProducer(String name, CamelEndpointConfiguration endpointConfiguration) {
        this.name = name;
        this.endpointConfiguration = endpointConfiguration;
    }

    public void send(final Message message, final TestContext context) {
        Exchange camelExchange;
        String endpointUri = context.replaceDynamicContentInString(this.endpointConfiguration.getEndpointUri());
        if (log.isDebugEnabled()) {
            log.debug("Sending message to camel endpoint: '" + endpointUri + "'");
        }
        if ((camelExchange = this.getProducerTemplate().send(endpointUri, new Processor(){

            public void process(Exchange exchange) throws Exception {
                CamelProducer.this.endpointConfiguration.getMessageConverter().convertOutbound(exchange, message, CamelProducer.this.endpointConfiguration, context);
            }
        })).getException() != null) {
            throw new CitrusRuntimeException("Sending message to camel endpoint resulted in exception", (Throwable)camelExchange.getException());
        }
        context.onOutboundMessage(message);
        log.info("Message was sent to camel endpoint '" + endpointUri + "'");
    }

    protected ProducerTemplate getProducerTemplate() {
        if (this.producerTemplate == null) {
            this.producerTemplate = this.endpointConfiguration.getCamelContext().createProducerTemplate();
        }
        return this.producerTemplate;
    }

    public String getName() {
        return this.name;
    }
}

