/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.camel.endpoint;

import com.consol.citrus.camel.endpoint.CamelConsumer;
import com.consol.citrus.camel.endpoint.CamelSyncEndpointConfiguration;
import com.consol.citrus.context.TestContext;
import com.consol.citrus.endpoint.PollableEndpointConfiguration;
import com.consol.citrus.exceptions.MessageTimeoutException;
import com.consol.citrus.message.correlation.CorrelationManager;
import com.consol.citrus.message.correlation.PollingCorrelationManager;
import com.consol.citrus.messaging.ReplyProducer;
import java.util.Map;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class CamelSyncConsumer
extends CamelConsumer
implements ReplyProducer {
    private static Logger log = LoggerFactory.getLogger(CamelSyncConsumer.class);
    private CorrelationManager<Exchange> correlationManager;
    private final CamelSyncEndpointConfiguration endpointConfiguration;

    public CamelSyncConsumer(String name, CamelSyncEndpointConfiguration endpointConfiguration) {
        super(name, endpointConfiguration);
        this.endpointConfiguration = endpointConfiguration;
        this.correlationManager = new PollingCorrelationManager((PollableEndpointConfiguration)endpointConfiguration, "Camel exchange not set up yet");
    }

    @Override
    public com.consol.citrus.message.Message receive(TestContext context, long timeout) {
        Exchange exchange;
        String endpointUri = context.replaceDynamicContentInString(this.endpointConfiguration.getEndpointUri());
        if (log.isDebugEnabled()) {
            log.debug("Receiving message from camel endpoint: '" + endpointUri + "'");
        }
        if ((exchange = this.getConsumerTemplate().receive(endpointUri, timeout)) == null) {
            throw new MessageTimeoutException(timeout, endpointUri);
        }
        log.info("Received message from camel endpoint: '" + endpointUri + "'");
        com.consol.citrus.message.Message message = this.endpointConfiguration.getMessageConverter().convertInbound(exchange, this.endpointConfiguration, context);
        context.onInboundMessage(message);
        String correlationKeyName = this.endpointConfiguration.getCorrelator().getCorrelationKeyName(this.getName());
        String correlationKey = this.endpointConfiguration.getCorrelator().getCorrelationKey(message);
        this.correlationManager.saveCorrelationKey(correlationKeyName, correlationKey, context);
        this.correlationManager.store(correlationKey, (Object)exchange);
        return message;
    }

    public void send(com.consol.citrus.message.Message message, TestContext context) {
        Assert.notNull((Object)message, (String)"Message is empty - unable to send empty message");
        String correlationKeyName = this.endpointConfiguration.getCorrelator().getCorrelationKeyName(this.getName());
        String correlationKey = this.correlationManager.getCorrelationKey(correlationKeyName, context);
        Exchange exchange = (Exchange)this.correlationManager.find(correlationKey, this.endpointConfiguration.getTimeout());
        Assert.notNull((Object)exchange, (String)("Failed to find camel exchange for message correlation key: '" + correlationKey + "'"));
        this.buildOutMessage(exchange, message);
        if (log.isDebugEnabled()) {
            log.debug("Sending reply message to camel endpoint: '" + exchange.getFromEndpoint() + "'");
        }
        this.getConsumerTemplate().doneUoW(exchange);
        context.onOutboundMessage(message);
        log.info("Message was sent to camel endpoint: '" + exchange.getFromEndpoint() + "'");
    }

    private void buildOutMessage(Exchange exchange, com.consol.citrus.message.Message message) {
        Message reply = exchange.getOut();
        for (Map.Entry header : message.getHeaders().entrySet()) {
            if (((String)header.getKey()).startsWith("citrus_")) continue;
            reply.setHeader((String)header.getKey(), header.getValue());
        }
        if (message.getHeader("citrus_camel_exchange_exception") != null) {
            String exceptionClass = message.getHeader("citrus_camel_exchange_exception").toString();
            String exceptionMsg = null;
            if (message.getHeader("citrus_camel_exchange_exception_message") != null) {
                exceptionMsg = message.getHeader("citrus_camel_exchange_exception_message").toString();
            }
            try {
                Class<?> exception = Class.forName(exceptionClass);
                if (exceptionMsg != null) {
                    exchange.setException((Throwable)exception.getConstructor(String.class).newInstance(exceptionMsg));
                } else {
                    exchange.setException((Throwable)exception.newInstance());
                }
            }
            catch (RuntimeException e) {
                log.warn("Unable to create proper exception instance for exchange!", (Throwable)e);
            }
            catch (Exception e) {
                log.warn("Unable to create proper exception instance for exchange!", (Throwable)e);
            }
        }
        reply.setBody(message.getPayload());
    }

    public void setCorrelationManager(CorrelationManager<Exchange> correlationManager) {
        this.correlationManager = correlationManager;
    }
}

