/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.camel.actions;

import com.consol.citrus.camel.actions.AbstractCamelRouteAction;
import com.consol.citrus.camel.endpoint.CamelSyncEndpoint;
import com.consol.citrus.camel.endpoint.CamelSyncEndpointConfiguration;
import com.consol.citrus.context.TestContext;
import com.consol.citrus.message.DefaultMessage;
import com.consol.citrus.message.Message;
import com.consol.citrus.validation.ValidationUtils;
import com.consol.citrus.variable.VariableUtils;
import org.apache.camel.ServiceStatus;
import org.apache.camel.builder.SimpleBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class CamelControlBusAction
extends AbstractCamelRouteAction {
    private static Logger log = LoggerFactory.getLogger(CamelControlBusAction.class);
    private final String action;
    private final String routeId;
    private final String languageType;
    private final String languageExpression;
    private final String result;

    public CamelControlBusAction(Builder builder) {
        super("controlbus", builder);
        this.action = builder.action;
        this.routeId = builder.routeId;
        this.languageType = builder.languageType;
        this.languageExpression = builder.languageExpression;
        this.result = builder.result;
    }

    public void doExecute(TestContext context) {
        CamelSyncEndpointConfiguration endpointConfiguration = new CamelSyncEndpointConfiguration();
        if (StringUtils.hasText((String)this.languageExpression)) {
            endpointConfiguration.setEndpointUri(String.format("controlbus:language:%s", context.replaceDynamicContentInString(this.languageType)));
        } else {
            endpointConfiguration.setEndpointUri(String.format("controlbus:route?routeId=%s&action=%s", context.replaceDynamicContentInString(this.routeId), context.replaceDynamicContentInString(this.action)));
        }
        endpointConfiguration.setCamelContext(this.camelContext);
        CamelSyncEndpoint camelEndpoint = new CamelSyncEndpoint(endpointConfiguration);
        String expression = context.replaceDynamicContentInString(VariableUtils.cutOffVariablesPrefix((String)this.languageExpression));
        camelEndpoint.createProducer().send((Message)new DefaultMessage((Object)(VariableUtils.isVariableName((String)this.languageExpression) ? "${" + expression + "}" : expression)), context);
        Message response = camelEndpoint.createConsumer().receive(context);
        if (StringUtils.hasText((String)this.result)) {
            String expectedResult = context.replaceDynamicContentInString(this.result);
            if (log.isDebugEnabled()) {
                log.debug(String.format("Validating Camel controlbus response = '%s'", expectedResult));
            }
            ValidationUtils.validateValues((Object)response.getPayload(String.class), (Object)expectedResult, (String)"camelControlBusResult", (TestContext)context);
            log.info("Validation of Camel controlbus response successful - All values OK");
        }
    }

    public String getAction() {
        return this.action;
    }

    public String getRouteId() {
        return this.routeId;
    }

    public String getResult() {
        return this.result;
    }

    public String getLanguageType() {
        return this.languageType;
    }

    public String getLanguageExpression() {
        return this.languageExpression;
    }

    public static final class Builder
    extends AbstractCamelRouteAction.Builder<CamelControlBusAction, Builder> {
        private String action;
        private String routeId;
        private String languageType = "simple";
        private String languageExpression = "";
        private String result;

        public Builder route(String id, String action) {
            this.routeId = id;
            this.action = action;
            return this;
        }

        public Builder language(SimpleBuilder simpleExpression) {
            this.language("simple", simpleExpression.getText());
            return this;
        }

        public Builder language(String language, String expression) {
            this.languageType = language;
            this.languageExpression = expression;
            return this;
        }

        public Builder result(ServiceStatus status) {
            this.result = status.name();
            return this;
        }

        public Builder result(String result) {
            this.result = result;
            return this;
        }

        public CamelControlBusAction build() {
            return new CamelControlBusAction(this);
        }
    }
}

