/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.camel.actions;

import com.consol.citrus.TestActionBuilder;
import com.consol.citrus.camel.actions.AbstractCamelRouteAction;
import com.consol.citrus.camel.actions.CamelControlBusAction;
import com.consol.citrus.camel.actions.CreateCamelRouteAction;
import com.consol.citrus.camel.actions.RemoveCamelRouteAction;
import com.consol.citrus.camel.actions.StartCamelRouteAction;
import com.consol.citrus.camel.actions.StopCamelRouteAction;
import com.consol.citrus.spi.ReferenceResolver;
import com.consol.citrus.spi.ReferenceResolverAware;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.camel.CamelContext;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.ModelCamelContext;
import org.springframework.util.Assert;

public class CamelRouteActionBuilder
implements TestActionBuilder.DelegatingTestActionBuilder<AbstractCamelRouteAction>,
ReferenceResolverAware {
    private ReferenceResolver referenceResolver;
    private CamelContext camelContext;
    private List<String> routeIds = new ArrayList<String>();
    private TestActionBuilder<? extends AbstractCamelRouteAction> delegate;

    public static CamelRouteActionBuilder camel() {
        return new CamelRouteActionBuilder();
    }

    public CamelRouteActionBuilder context(String camelContext) {
        Assert.notNull((Object)this.referenceResolver, (String)"Citrus bean reference resolver is not initialized!");
        this.camelContext = (CamelContext)this.referenceResolver.resolve(camelContext, ModelCamelContext.class);
        return this;
    }

    public CamelRouteActionBuilder context(CamelContext camelContext) {
        this.camelContext = camelContext;
        return this;
    }

    public CamelRouteActionBuilder routes(String ... routeIds) {
        return this.routes(Arrays.asList(routeIds));
    }

    public CamelRouteActionBuilder routes(List<String> routeIds) {
        this.routeIds.addAll(routeIds);
        return this;
    }

    public CreateCamelRouteAction.Builder create(RouteBuilder routeBuilder) {
        if (this.getCamelContext() == null) {
            this.context(routeBuilder.getContext());
        }
        CreateCamelRouteAction.Builder builder = ((CreateCamelRouteAction.Builder)((Object)((CreateCamelRouteAction.Builder)((Object)new CreateCamelRouteAction.Builder().context(this.getCamelContext()))).routeIds(this.routeIds))).route(routeBuilder);
        this.delegate = builder;
        return builder;
    }

    public CreateCamelRouteAction.Builder create(String routeContext) {
        CreateCamelRouteAction.Builder builder = ((CreateCamelRouteAction.Builder)((Object)((CreateCamelRouteAction.Builder)((Object)new CreateCamelRouteAction.Builder().context(this.getCamelContext()))).routeIds(this.routeIds))).routeContext(routeContext);
        this.delegate = builder;
        return builder;
    }

    public CamelControlBusAction.Builder controlBus() {
        CamelControlBusAction.Builder builder = (CamelControlBusAction.Builder)((Object)((CamelControlBusAction.Builder)((Object)new CamelControlBusAction.Builder().context(this.getCamelContext()))).routeIds(this.routeIds));
        this.delegate = builder;
        return builder;
    }

    public StartCamelRouteAction.Builder start(String ... routes) {
        StartCamelRouteAction.Builder builder = (StartCamelRouteAction.Builder)((Object)((StartCamelRouteAction.Builder)((Object)((StartCamelRouteAction.Builder)((Object)new StartCamelRouteAction.Builder().context(this.getCamelContext()))).routeIds(this.routeIds))).routes(routes));
        this.delegate = builder;
        return builder;
    }

    public StopCamelRouteAction.Builder stop(String ... routes) {
        StopCamelRouteAction.Builder builder = (StopCamelRouteAction.Builder)((Object)((StopCamelRouteAction.Builder)((Object)((StopCamelRouteAction.Builder)((Object)new StopCamelRouteAction.Builder().context(this.getCamelContext()))).routeIds(this.routeIds))).routes(routes));
        this.delegate = builder;
        return builder;
    }

    public RemoveCamelRouteAction.Builder remove(String ... routes) {
        RemoveCamelRouteAction.Builder builder = (RemoveCamelRouteAction.Builder)((Object)((RemoveCamelRouteAction.Builder)((Object)((RemoveCamelRouteAction.Builder)((Object)new RemoveCamelRouteAction.Builder().context(this.getCamelContext()))).routeIds(this.routeIds))).routes(routes));
        this.delegate = builder;
        return builder;
    }

    public CamelRouteActionBuilder withReferenceResolver(ReferenceResolver referenceResolver) {
        this.referenceResolver = referenceResolver;
        return this;
    }

    protected CamelContext getCamelContext() {
        if (this.camelContext == null) {
            Assert.notNull((Object)this.referenceResolver, (String)"Citrus bean reference resolver is not initialized!");
            this.camelContext = this.referenceResolver.isResolvable("citrusCamelContext") ? (CamelContext)this.referenceResolver.resolve("citrusCamelContext", ModelCamelContext.class) : (CamelContext)this.referenceResolver.resolve(ModelCamelContext.class);
        }
        return this.camelContext;
    }

    public AbstractCamelRouteAction build() {
        Assert.notNull(this.delegate, (String)"Missing delegate action to build");
        return (AbstractCamelRouteAction)this.delegate.build();
    }

    public TestActionBuilder<?> getDelegate() {
        return this.delegate;
    }

    public void setReferenceResolver(ReferenceResolver referenceResolver) {
        if (referenceResolver == null) {
            this.referenceResolver = referenceResolver;
            if (this.delegate instanceof ReferenceResolverAware) {
                ((ReferenceResolverAware)this.delegate).setReferenceResolver(referenceResolver);
            }
        }
    }
}

