/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.camel.actions;

import com.consol.citrus.camel.actions.AbstractCamelRouteAction;
import com.consol.citrus.context.TestContext;
import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.xml.StringSource;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.transform.Source;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spring.CamelRouteContextFactoryBean;
import org.apache.camel.spring.SpringModelJAXBContextFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.util.StringUtils;

public class CreateCamelRouteAction
extends AbstractCamelRouteAction {
    private static Logger log = LoggerFactory.getLogger(CreateCamelRouteAction.class);
    private final List<RouteDefinition> routes;
    private final String routeContext;

    public CreateCamelRouteAction(Builder builder) {
        super("create-routes", builder);
        this.routes = builder.routes;
        this.routeContext = builder.routeContext;
    }

    public void doExecute(TestContext context) {
        List routesToUse;
        if (StringUtils.hasText((String)this.routeContext)) {
            try {
                Object value = this.getJaxbContext().createUnmarshaller().unmarshal((Source)new StringSource(context.replaceDynamicContentInString(this.routeContext)));
                if (!(value instanceof CamelRouteContextFactoryBean)) {
                    throw new CitrusRuntimeException(String.format("Failed to parse routes from given route context - expected %s but found %s", CamelRouteContextFactoryBean.class, value.getClass()));
                }
                CamelRouteContextFactoryBean factoryBean = (CamelRouteContextFactoryBean)value;
                routesToUse = factoryBean.getRoutes();
            }
            catch (JAXBException e) {
                throw new BeanDefinitionStoreException("Failed to create the JAXB unmarshaller", (Throwable)e);
            }
        } else {
            routesToUse = this.routes;
        }
        try {
            this.camelContext.addRoutes((RoutesBuilder)new RouteBuilder(this.camelContext){

                public void configure() throws Exception {
                    for (RouteDefinition routeDefinition : routesToUse) {
                        try {
                            this.getRouteCollection().getRoutes().add(routeDefinition);
                            this.log.info(String.format("Created new Camel route '%s' in context '%s'", routeDefinition.getId(), CreateCamelRouteAction.this.camelContext.getName()));
                        }
                        catch (Exception e) {
                            throw new CitrusRuntimeException(String.format("Failed to create route definition '%s' in context '%s'", routeDefinition.getId(), CreateCamelRouteAction.this.camelContext.getName()), (Throwable)e);
                        }
                    }
                }
            });
        }
        catch (Exception e) {
            throw new CitrusRuntimeException(String.format("Failed to create route definitions in context '%s'", this.camelContext.getName()), (Throwable)e);
        }
    }

    public JAXBContext getJaxbContext() throws JAXBException {
        return new SpringModelJAXBContextFactory().newJAXBContext();
    }

    public List<RouteDefinition> getRoutes() {
        return this.routes;
    }

    public String getRouteContext() {
        return this.routeContext;
    }

    public static final class Builder
    extends AbstractCamelRouteAction.Builder<CreateCamelRouteAction, Builder> {
        private List<RouteDefinition> routes = new ArrayList<RouteDefinition>();
        private String routeContext;

        public Builder route(RouteBuilder routeBuilder) {
            try {
                if (routeBuilder.getContext() != null && !routeBuilder.getContext().equals(this.camelContext)) {
                    routeBuilder.configureRoutes(this.camelContext);
                } else {
                    routeBuilder.configure();
                }
                this.routes(routeBuilder.getRouteCollection().getRoutes());
            }
            catch (Exception e) {
                throw new CitrusRuntimeException("Failed to configure route definitions with camel context", (Throwable)e);
            }
            return this;
        }

        public Builder routeContext(String routeContext) {
            this.routeContext = routeContext;
            return this;
        }

        public Builder routes(List<RouteDefinition> routes) {
            this.routes.addAll(routes);
            return this;
        }

        public CreateCamelRouteAction build() {
            return new CreateCamelRouteAction(this);
        }
    }
}

