/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.camel.config.annotation;

import com.consol.citrus.TestActor;
import com.consol.citrus.camel.config.annotation.CamelEndpointConfig;
import com.consol.citrus.camel.endpoint.CamelEndpoint;
import com.consol.citrus.camel.endpoint.CamelEndpointBuilder;
import com.consol.citrus.camel.message.CamelMessageConverter;
import com.consol.citrus.config.annotation.AnnotationConfigParser;
import com.consol.citrus.spi.ReferenceResolver;
import org.apache.camel.CamelContext;
import org.springframework.util.StringUtils;

public class CamelEndpointConfigParser
implements AnnotationConfigParser<CamelEndpointConfig, CamelEndpoint> {
    public CamelEndpoint parse(CamelEndpointConfig annotation, ReferenceResolver referenceResolver) {
        CamelEndpointBuilder builder = new CamelEndpointBuilder();
        builder.endpointUri(annotation.endpointUri());
        if (StringUtils.hasText((String)annotation.camelContext())) {
            builder.camelContext((CamelContext)referenceResolver.resolve(annotation.camelContext(), CamelContext.class));
        } else if (referenceResolver.isResolvable("camelContext")) {
            builder.camelContext((CamelContext)referenceResolver.resolve("camelContext", CamelContext.class));
        } else {
            builder.camelContext((CamelContext)referenceResolver.resolve(CamelContext.class));
        }
        if (StringUtils.hasText((String)annotation.messageConverter())) {
            builder.messageConverter((CamelMessageConverter)referenceResolver.resolve(annotation.messageConverter(), CamelMessageConverter.class));
        }
        builder.timeout(annotation.timeout());
        if (StringUtils.hasText((String)annotation.actor())) {
            builder.actor((TestActor)referenceResolver.resolve(annotation.actor(), TestActor.class));
        }
        return (CamelEndpoint)builder.initialize().build();
    }
}

