/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.camel.message;

import com.consol.citrus.context.TestContext;
import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.message.Message;
import com.consol.citrus.message.MessageProcessor;
import com.consol.citrus.spi.ReferenceResolver;
import com.consol.citrus.spi.ReferenceResolverAware;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Processor;
import org.apache.camel.support.DefaultExchange;

public class CamelMessageProcessor
implements MessageProcessor {
    private final CamelContext camelContext;
    private final Processor processor;

    public CamelMessageProcessor(CamelContext camelContext, Processor processor) {
        this.camelContext = camelContext;
        this.processor = processor;
    }

    public void process(Message message, TestContext context) {
        Exchange exchange;
        if (message.getPayload() instanceof Exchange) {
            exchange = (Exchange)message.getPayload(Exchange.class);
        } else {
            exchange = new DefaultExchange(this.camelContext);
            exchange.setPattern(ExchangePattern.InOut);
            for (Map.Entry header : message.getHeaders().entrySet()) {
                exchange.getMessage().setHeader((String)header.getKey(), header.getValue());
            }
            exchange.getMessage().setBody(message.getPayload());
        }
        try {
            this.processor.process(exchange);
        }
        catch (Exception e) {
            throw new CitrusRuntimeException("Failed to process message with Apache Camel processor", (Throwable)e);
        }
        if (exchange.getException() != null) {
            throw new CitrusRuntimeException("Failed to process message with Apache Camel processor", (Throwable)exchange.getException());
        }
        if (!(message.getPayload() instanceof Exchange)) {
            message.setPayload(exchange.getMessage().getBody());
            exchange.getMessage().getHeaders().entrySet().stream().filter(entry -> !((String)entry.getKey()).equals("citrus_message_id")).forEach(entry -> message.setHeader((String)entry.getKey(), entry.getValue()));
        }
    }

    public static abstract class CamelMessageProcessorBuilder<T extends CamelMessageProcessor, B extends CamelMessageProcessorBuilder<T, B>>
    implements MessageProcessor.Builder<T, B>,
    ReferenceResolverAware {
        protected CamelContext camelContext;
        protected ReferenceResolver referenceResolver;
        private final B self = this;

        public B camelContext(CamelContext camelContext) {
            this.camelContext = camelContext;
            return this.self;
        }

        public B withReferenceResolver(ReferenceResolver referenceResolver) {
            this.referenceResolver = referenceResolver;
            return this.self;
        }

        public final T build() {
            if (this.camelContext == null) {
                if (this.referenceResolver != null) {
                    this.camelContext = (CamelContext)this.referenceResolver.resolve(CamelContext.class);
                } else {
                    throw new CitrusRuntimeException("Missing proper Camel context for message processor - either set explicit context or provide a reference resolver");
                }
            }
            return this.doBuild();
        }

        public abstract T doBuild();

        public void setReferenceResolver(ReferenceResolver referenceResolver) {
            this.referenceResolver = referenceResolver;
        }
    }

    public static class Builder
    extends CamelMessageProcessorBuilder<CamelMessageProcessor, Builder> {
        private Processor processor;

        public static Builder process(Processor processor) {
            Builder builder = new Builder();
            builder.processor = processor;
            return builder;
        }

        @Override
        public CamelMessageProcessor doBuild() {
            return new CamelMessageProcessor(this.camelContext, this.processor);
        }
    }
}

