/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.camel.config.annotation;

import com.consol.citrus.TestActor;
import com.consol.citrus.camel.config.annotation.CamelSyncEndpointConfig;
import com.consol.citrus.camel.endpoint.CamelSyncEndpoint;
import com.consol.citrus.camel.endpoint.CamelSyncEndpointBuilder;
import com.consol.citrus.camel.message.CamelMessageConverter;
import com.consol.citrus.config.annotation.AnnotationConfigParser;
import com.consol.citrus.message.MessageCorrelator;
import com.consol.citrus.spi.ReferenceResolver;
import org.apache.camel.CamelContext;
import org.springframework.util.StringUtils;

public class CamelSyncEndpointConfigParser
implements AnnotationConfigParser<CamelSyncEndpointConfig, CamelSyncEndpoint> {
    public CamelSyncEndpoint parse(CamelSyncEndpointConfig annotation, ReferenceResolver referenceResolver) {
        CamelSyncEndpointBuilder builder = new CamelSyncEndpointBuilder();
        builder.endpointUri(annotation.endpointUri());
        if (StringUtils.hasText((String)annotation.camelContext())) {
            builder.camelContext((CamelContext)referenceResolver.resolve(annotation.camelContext(), CamelContext.class));
        } else if (referenceResolver.isResolvable("camelContext")) {
            builder.camelContext((CamelContext)referenceResolver.resolve("camelContext", CamelContext.class));
        } else {
            builder.camelContext((CamelContext)referenceResolver.resolve(CamelContext.class));
        }
        if (StringUtils.hasText((String)annotation.messageConverter())) {
            builder.messageConverter((CamelMessageConverter)referenceResolver.resolve(annotation.messageConverter(), CamelMessageConverter.class));
        }
        builder.timeout(annotation.timeout());
        if (StringUtils.hasText((String)annotation.actor())) {
            builder.actor((TestActor)referenceResolver.resolve(annotation.actor(), TestActor.class));
        }
        if (StringUtils.hasText((String)annotation.correlator())) {
            builder.correlator((MessageCorrelator)referenceResolver.resolve(annotation.correlator(), MessageCorrelator.class));
        }
        builder.pollingInterval(annotation.pollingInterval());
        return (CamelSyncEndpoint)builder.initialize().build();
    }
}

