/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.camel.endpoint;

import com.consol.citrus.camel.endpoint.CamelProducer;
import com.consol.citrus.camel.endpoint.CamelSyncEndpointConfiguration;
import com.consol.citrus.context.TestContext;
import com.consol.citrus.endpoint.PollableEndpointConfiguration;
import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.exceptions.ReplyMessageTimeoutException;
import com.consol.citrus.message.Message;
import com.consol.citrus.message.correlation.CorrelationManager;
import com.consol.citrus.message.correlation.PollingCorrelationManager;
import com.consol.citrus.messaging.ReplyConsumer;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CamelSyncProducer
extends CamelProducer
implements ReplyConsumer {
    private static Logger log = LoggerFactory.getLogger(CamelSyncProducer.class);
    private CorrelationManager<Message> correlationManager;
    private final CamelSyncEndpointConfiguration endpointConfiguration;

    public CamelSyncProducer(String name, CamelSyncEndpointConfiguration endpointConfiguration) {
        super(name, endpointConfiguration);
        this.endpointConfiguration = endpointConfiguration;
        this.correlationManager = new PollingCorrelationManager((PollableEndpointConfiguration)endpointConfiguration, "Reply message did not arrive yet");
    }

    @Override
    public void send(final Message message, final TestContext context) {
        String endpointUri;
        if (this.endpointConfiguration.getEndpointUri() != null) {
            endpointUri = context.replaceDynamicContentInString(this.endpointConfiguration.getEndpointUri());
        } else if (this.endpointConfiguration.getEndpoint() != null) {
            endpointUri = this.endpointConfiguration.getEndpoint().getEndpointUri();
        } else {
            throw new CitrusRuntimeException("Missing endpoint or endpointUri on Camel producer");
        }
        if (log.isDebugEnabled()) {
            log.debug("Sending message to camel endpoint: '" + endpointUri + "'");
        }
        String correlationKeyName = this.endpointConfiguration.getCorrelator().getCorrelationKeyName(this.getName());
        String correlationKey = this.endpointConfiguration.getCorrelator().getCorrelationKey(message);
        this.correlationManager.saveCorrelationKey(correlationKeyName, correlationKey, context);
        context.onOutboundMessage(message);
        Exchange response = this.getProducerTemplate().request(endpointUri, new Processor(){

            public void process(Exchange exchange) throws Exception {
                CamelSyncProducer.this.endpointConfiguration.getMessageConverter().convertOutbound(exchange, message, CamelSyncProducer.this.endpointConfiguration, context);
                log.info("Message was sent to camel endpoint: '" + endpointUri + "'");
            }
        });
        log.info("Received synchronous reply message on camel endpoint: '" + endpointUri + "'");
        Message replyMessage = this.endpointConfiguration.getMessageConverter().convertInbound(response, this.endpointConfiguration, context);
        context.onInboundMessage(replyMessage);
        this.correlationManager.store(correlationKey, (Object)replyMessage);
    }

    public Message receive(TestContext context) {
        return this.receive(this.correlationManager.getCorrelationKey(this.endpointConfiguration.getCorrelator().getCorrelationKeyName(this.getName()), context), context);
    }

    public Message receive(String selector, TestContext context) {
        return this.receive(selector, context, this.endpointConfiguration.getTimeout());
    }

    public Message receive(TestContext context, long timeout) {
        return this.receive(this.correlationManager.getCorrelationKey(this.endpointConfiguration.getCorrelator().getCorrelationKeyName(this.getName()), context), context, timeout);
    }

    public Message receive(String selector, TestContext context, long timeout) {
        Message message = (Message)this.correlationManager.find(selector, timeout);
        if (message == null) {
            String endpointUri;
            if (this.endpointConfiguration.getEndpointUri() != null) {
                endpointUri = context.replaceDynamicContentInString(this.endpointConfiguration.getEndpointUri());
            } else if (this.endpointConfiguration.getEndpoint() != null) {
                endpointUri = this.endpointConfiguration.getEndpoint().getEndpointUri();
            } else {
                throw new CitrusRuntimeException("Missing endpoint or endpointUri on Camel consumer");
            }
            throw new ReplyMessageTimeoutException(timeout, endpointUri);
        }
        return message;
    }

    public void setCorrelationManager(CorrelationManager<Message> correlationManager) {
        this.correlationManager = correlationManager;
    }
}

