/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.camel.message;

import com.consol.citrus.camel.message.CamelMessageProcessor;
import com.consol.citrus.camel.message.format.DataFormatClauseSupport;
import org.apache.camel.CamelContext;
import org.apache.camel.Processor;
import org.apache.camel.builder.DataFormatClause;
import org.apache.camel.model.DataFormatDefinition;
import org.apache.camel.reifier.dataformat.DataFormatReifier;
import org.apache.camel.support.processor.MarshalProcessor;
import org.apache.camel.support.processor.UnmarshalProcessor;

public class CamelDataFormatMessageProcessor
extends CamelMessageProcessor {
    public CamelDataFormatMessageProcessor(CamelContext camelContext, Processor processor) {
        super(camelContext, processor);
    }

    public static class Builder
    extends CamelMessageProcessor.CamelMessageProcessorBuilder<CamelDataFormatMessageProcessor, Builder> {
        private DataFormatClauseSupport<Builder> dataFormat;
        private DataFormatClause.Operation operation;

        public static DataFormatClauseSupport<Builder> marshal() {
            Builder builder = new Builder();
            builder.operation = DataFormatClause.Operation.Marshal;
            builder.dataFormat = new DataFormatClauseSupport<Builder>(builder, builder.operation);
            return builder.dataFormat;
        }

        public static DataFormatClauseSupport<Builder> unmarshal() {
            Builder builder = new Builder();
            builder.operation = DataFormatClause.Operation.Unmarshal;
            builder.dataFormat = new DataFormatClauseSupport<Builder>(builder, builder.operation);
            return builder.dataFormat;
        }

        @Override
        public CamelDataFormatMessageProcessor doBuild() {
            if (this.dataFormat.getCamelContext() != null) {
                this.camelContext = this.dataFormat.getCamelContext();
            }
            Object processor = this.operation.equals((Object)DataFormatClause.Operation.Marshal) ? new MarshalProcessor(DataFormatReifier.getDataFormat((CamelContext)this.camelContext, (DataFormatDefinition)this.dataFormat.getDataFormat())) : new UnmarshalProcessor(DataFormatReifier.getDataFormat((CamelContext)this.camelContext, (DataFormatDefinition)this.dataFormat.getDataFormat()));
            return new CamelDataFormatMessageProcessor(this.camelContext, (Processor)processor);
        }
    }
}

