/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.camel.actions;

import com.consol.citrus.camel.actions.AbstractCamelRouteAction;
import com.consol.citrus.context.TestContext;
import com.consol.citrus.exceptions.CitrusRuntimeException;
import org.apache.camel.impl.engine.AbstractCamelContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoveCamelRouteAction
extends AbstractCamelRouteAction {
    private static Logger log = LoggerFactory.getLogger(RemoveCamelRouteAction.class);

    public RemoveCamelRouteAction(Builder builder) {
        super("remove-routes", builder);
    }

    public void doExecute(TestContext context) {
        for (String routeId : this.routeIds) {
            String route = context.replaceDynamicContentInString(routeId);
            try {
                if (this.camelContext instanceof AbstractCamelContext && !((AbstractCamelContext)this.camelContext).getRouteStatus(route).isStopped()) {
                    throw new CitrusRuntimeException("Camel routes must be stopped before removal!");
                }
                if (this.camelContext.removeRoute(route)) {
                    log.info(String.format("Removed Camel route '%s' from context '%s'", route, this.camelContext.getName()));
                    continue;
                }
                throw new CitrusRuntimeException(String.format("Failed to remove Camel route '%s' from context '%s'", route, this.camelContext.getName()));
            }
            catch (CitrusRuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new CitrusRuntimeException(String.format("Failed to remove Camel route '%s' from context '%s'", route, this.camelContext.getName()), (Throwable)e);
            }
        }
    }

    public static final class Builder
    extends AbstractCamelRouteAction.Builder<RemoveCamelRouteAction, Builder> {
        public RemoveCamelRouteAction build() {
            return new RemoveCamelRouteAction(this);
        }
    }
}

