/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.camel.dsl;

import com.consol.citrus.camel.actions.CamelActionBuilder;
import com.consol.citrus.camel.actions.CamelControlBusAction;
import com.consol.citrus.camel.actions.CamelRouteActionBuilder;
import com.consol.citrus.camel.dsl.EndpointBuilderFactorySupport;
import com.consol.citrus.camel.message.CamelDataFormatMessageProcessor;
import com.consol.citrus.camel.message.CamelMessageProcessor;
import com.consol.citrus.camel.message.CamelRouteProcessor;
import com.consol.citrus.camel.message.CamelTransformMessageProcessor;
import com.consol.citrus.camel.message.format.DataFormatClauseSupport;
import com.consol.citrus.endpoint.EndpointUriBuilder;
import java.util.function.Function;
import org.apache.camel.CamelContext;
import org.apache.camel.Processor;
import org.apache.camel.builder.ExpressionClauseSupport;
import org.apache.camel.model.OutputDefinition;
import org.apache.camel.model.ProcessorDefinition;

public class CamelSupport {
    private CamelContext camelContext;

    public static CamelSupport camel() {
        return new CamelSupport();
    }

    public static CamelSupport camel(CamelContext camelContext) {
        return new CamelSupport().camelContext(camelContext);
    }

    public CamelSupport camelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
        return this;
    }

    public String endpoint(EndpointUriBuilder builder) {
        return "camel:" + builder.getUri();
    }

    public EndpointBuilderFactorySupport endpoints() {
        return new EndpointBuilderFactorySupport();
    }

    public CamelControlBusAction.Builder controlBus() {
        return new CamelActionBuilder().camelContext(this.camelContext).controlBus();
    }

    public CamelMessageProcessor.Builder process(Processor processor) {
        return (CamelMessageProcessor.Builder)CamelMessageProcessor.Builder.process(processor).camelContext(this.camelContext);
    }

    public CamelRouteActionBuilder route() {
        return new CamelActionBuilder().camelContext(this.camelContext).route();
    }

    public CamelRouteProcessor.Builder route(Function<OutputDefinition<CamelRouteProcessor.Builder>, ProcessorDefinition<?>> configurer) {
        CamelRouteProcessor.Builder builder = CamelRouteProcessor.Builder.route().camelContext(this.camelContext);
        configurer.apply(builder);
        return builder;
    }

    public ExpressionClauseSupport<CamelTransformMessageProcessor.Builder> transform() {
        return CamelTransformMessageProcessor.Builder.transform(this.camelContext);
    }

    public CamelTransformMessageProcessor.Builder convertBodyTo(Class<?> type) {
        return (CamelTransformMessageProcessor.Builder)CamelTransformMessageProcessor.Builder.transform(this.camelContext).body(type);
    }

    public DataFormatClauseSupport<CamelDataFormatMessageProcessor.Builder> marshal() {
        return CamelDataFormatMessageProcessor.Builder.marshal().camelContext(this.camelContext);
    }

    public DataFormatClauseSupport<CamelDataFormatMessageProcessor.Builder> unmarshal() {
        return CamelDataFormatMessageProcessor.Builder.unmarshal().camelContext(this.camelContext);
    }
}

