/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.camel.endpoint;

import com.consol.citrus.camel.endpoint.CamelEndpointConfiguration;
import com.consol.citrus.context.TestContext;
import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.exceptions.MessageTimeoutException;
import com.consol.citrus.message.Message;
import com.consol.citrus.messaging.Consumer;
import org.apache.camel.ConsumerTemplate;
import org.apache.camel.Exchange;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CamelConsumer
implements Consumer {
    private final CamelEndpointConfiguration endpointConfiguration;
    private final String name;
    private ConsumerTemplate consumerTemplate;
    private static Logger log = LoggerFactory.getLogger(CamelConsumer.class);

    public CamelConsumer(String name, CamelEndpointConfiguration endpointConfiguration) {
        this.name = name;
        this.endpointConfiguration = endpointConfiguration;
    }

    public Message receive(TestContext context) {
        return this.receive(context, this.endpointConfiguration.getTimeout());
    }

    public Message receive(TestContext context, long timeout) {
        Exchange exchange;
        String endpointUri;
        if (this.endpointConfiguration.getEndpointUri() != null) {
            endpointUri = context.replaceDynamicContentInString(this.endpointConfiguration.getEndpointUri());
        } else if (this.endpointConfiguration.getEndpoint() != null) {
            endpointUri = this.endpointConfiguration.getEndpoint().getEndpointUri();
        } else {
            throw new CitrusRuntimeException("Missing endpoint or endpointUri on Camel consumer");
        }
        if (log.isDebugEnabled()) {
            log.debug("Receiving message from camel endpoint: '" + endpointUri + "'");
        }
        if ((exchange = this.endpointConfiguration.getEndpoint() != null ? this.getConsumerTemplate().receive(this.endpointConfiguration.getEndpoint(), timeout) : this.getConsumerTemplate().receive(endpointUri, timeout)) == null) {
            throw new MessageTimeoutException(timeout, endpointUri);
        }
        log.info("Received message from camel endpoint: '" + endpointUri + "'");
        Message message = this.endpointConfiguration.getMessageConverter().convertInbound(exchange, this.endpointConfiguration, context);
        context.onInboundMessage(message);
        return message;
    }

    protected ConsumerTemplate getConsumerTemplate() {
        if (this.consumerTemplate == null) {
            this.consumerTemplate = this.endpointConfiguration.getCamelContext().createConsumerTemplate();
        }
        return this.consumerTemplate;
    }

    public String getName() {
        return this.name;
    }
}

