/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.camel.message;

import com.consol.citrus.camel.dsl.CamelContextAware;
import com.consol.citrus.camel.message.CamelMessageProcessor;
import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.message.MessageProcessor;
import com.consol.citrus.spi.ReferenceResolver;
import com.consol.citrus.spi.ReferenceResolverAware;
import java.util.UUID;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.OutputDefinition;
import org.apache.camel.model.RouteDefinition;

public class CamelRouteProcessor
extends CamelMessageProcessor {
    public CamelRouteProcessor(Builder builder) {
        super(builder.camelContext, new RouteProcessor(builder.routeId, builder.routeBuilder));
        try {
            builder.camelContext.addRoutes((RoutesBuilder)builder.routeBuilder);
        }
        catch (Exception e) {
            throw new CitrusRuntimeException(String.format("Failed to create route definitions in context '%s'", builder.camelContext.getName()), (Throwable)e);
        }
    }

    private static class RouteProcessor
    implements Processor {
        private final String routeId;
        private final RouteBuilder routeBuilder;

        public RouteProcessor(String routeId, RouteBuilder routeBuilder) {
            this.routeId = routeId;
            this.routeBuilder = routeBuilder;
        }

        public void process(Exchange exchange) throws Exception {
            try {
                this.routeBuilder.getContext().createProducerTemplate().send("direct:" + this.routeId, exchange);
            }
            finally {
                this.routeBuilder.getContext().removeRoute(this.routeId);
            }
        }
    }

    public static class Builder
    extends OutputDefinition<Builder>
    implements MessageProcessor.Builder<CamelRouteProcessor, Builder>,
    ReferenceResolverAware,
    CamelContextAware<Builder> {
        private String routeId = "citrus-" + UUID.randomUUID();
        private RouteBuilder routeBuilder;
        protected CamelContext camelContext;
        protected ReferenceResolver referenceResolver;

        public static Builder route() {
            return new Builder();
        }

        public static Builder route(RouteBuilder routeBuilder) {
            Builder builder = new Builder();
            builder.routeBuilder = routeBuilder;
            return builder;
        }

        public Builder routeId(String id) {
            this.routeId = id;
            return (Builder)super.routeId(id);
        }

        @Override
        public Builder camelContext(CamelContext camelContext) {
            this.camelContext = camelContext;
            return this;
        }

        public Builder withReferenceResolver(ReferenceResolver referenceResolver) {
            this.referenceResolver = referenceResolver;
            return this;
        }

        public final CamelRouteProcessor build() {
            if (this.camelContext == null) {
                if (this.referenceResolver != null) {
                    this.camelContext = (CamelContext)this.referenceResolver.resolve(CamelContext.class);
                } else {
                    throw new CitrusRuntimeException("Missing proper Camel context for message processor - either set explicit context or provide a reference resolver");
                }
            }
            if (this.routeBuilder == null) {
                this.routeBuilder = new RouteBuilder(this.camelContext){

                    public void configure() throws Exception {
                        RouteDefinition routeDefinition = this.from("direct:" + routeId).routeId(routeId);
                        routeDefinition.setOutputs(this.getOutputs());
                    }
                };
            }
            return new CamelRouteProcessor(this);
        }

        public void setReferenceResolver(ReferenceResolver referenceResolver) {
            this.referenceResolver = referenceResolver;
        }
    }
}

