/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.cucumber.step.runner.core;

import com.consol.citrus.CitrusSettings;
import com.consol.citrus.TestActionBuilder;
import com.consol.citrus.TestCaseRunner;
import com.consol.citrus.actions.ReceiveMessageAction;
import com.consol.citrus.actions.SendMessageAction;
import com.consol.citrus.annotations.CitrusResource;
import com.consol.citrus.cucumber.message.MessageCreators;
import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.message.DefaultMessage;
import com.consol.citrus.message.Message;
import io.cucumber.java.Before;
import io.cucumber.java.en.And;
import io.cucumber.java.en.Given;
import io.cucumber.java.en.Then;
import io.cucumber.java.en.When;
import java.util.HashMap;
import java.util.Map;

public class MessagingSteps {
    @CitrusResource
    private TestCaseRunner runner;
    private MessageCreators messageCreators;
    private Map<String, Message> messages;

    @Before
    public void before() {
        this.messageCreators = new MessageCreators();
        this.messages = new HashMap<String, Message>();
    }

    @Given(value="^message creator ([^\\s]+)$")
    public void messageCreator(String type) {
        this.messageCreators.addType(type);
    }

    @Given(value="^message ([^\\s]+)$")
    public void message(String messageId) {
        this.messages.put(messageId, (Message)new DefaultMessage());
    }

    @When(value="^<([^>]+)> sends message <([^>]+)>$")
    public void sendMessage(String endpoint, String messageId) {
        if (this.messages.containsKey(messageId)) {
            this.runner.when((TestActionBuilder)((SendMessageAction.Builder)SendMessageAction.Builder.send().endpoint(endpoint)).message((Message)new DefaultMessage(this.messages.get(messageId))));
        } else {
            this.runner.when((TestActionBuilder)((SendMessageAction.Builder)SendMessageAction.Builder.send().endpoint(endpoint)).message(this.messageCreators.createMessage(messageId)));
        }
    }

    @Then(value="^<([^>]+)> should send message <([^>]+)>$")
    public void shouldSendMessage(String endpoint, String messageName) {
        this.sendMessage(endpoint, messageName);
    }

    @When(value="^<([^>]+)> sends$")
    public void doSendMessage(String endpoint, String payload) {
        this.runner.when((TestActionBuilder)((SendMessageAction.Builder)SendMessageAction.Builder.send().endpoint(endpoint)).payload(payload));
    }

    @When(value="^<([^>]+)> sends \"([^\"]*)\"$")
    public void sendPayload(String endpoint, String payload) {
        this.doSendMessage(endpoint, payload);
    }

    @Then(value="^<([^>]+)> should send \"([^\"]*)\"$")
    public void shouldSend(String endpoint, String payload) {
        this.doSendMessage(endpoint, payload);
    }

    @Then(value="^<([^>]+)> should send$")
    public void shouldSendPayload(String endpoint, String payload) {
        this.doSendMessage(endpoint, payload);
    }

    @When(value="^<([^>]+)> receives message <([^>]+)>$")
    public void receiveDefaultMessage(String endpoint, String messageName) {
        this.receiveMessage(endpoint, CitrusSettings.DEFAULT_MESSAGE_TYPE, messageName);
    }

    @When(value="^<([^>]+)> receives ([^\\s]+) message <([^>]+)>$")
    public void receiveMessage(String endpoint, String type, String messageId) {
        if (this.messages.containsKey(messageId)) {
            this.runner.when((TestActionBuilder)((ReceiveMessageAction.Builder)((ReceiveMessageAction.Builder)ReceiveMessageAction.Builder.receive().endpoint(endpoint)).messageType(type)).message((Message)new DefaultMessage(this.messages.get(messageId))));
        } else {
            this.runner.when((TestActionBuilder)((ReceiveMessageAction.Builder)((ReceiveMessageAction.Builder)ReceiveMessageAction.Builder.receive().endpoint(endpoint)).messageType(type)).message(this.messageCreators.createMessage(messageId)));
        }
    }

    @Then(value="^<([^>]+)> should receive message <([^>]+)>$")
    public void shouldReceiveDefaultMessage(String endpoint, String messageName) {
        this.receiveMessage(endpoint, CitrusSettings.DEFAULT_MESSAGE_TYPE, messageName);
    }

    @Then(value="^<([^>]+)> should receive ([^\\s]+) message <([^>]+)>$")
    public void shouldReceiveMessage(String endpoint, String type, String messageName) {
        this.receiveMessage(endpoint, type, messageName);
    }

    @When(value="^<([^>]+)> receives ([^\\s]+) \"([^\"]*)\"$")
    public void doReceiveMessage(String endpoint, String type, String payload) {
        this.runner.when((TestActionBuilder)((ReceiveMessageAction.Builder)((ReceiveMessageAction.Builder)ReceiveMessageAction.Builder.receive().endpoint(endpoint)).messageType(type)).payload(payload));
    }

    @When(value="^<([^>]+)> receives \"([^\"]*)\"$")
    public void receiveDefault(String endpoint, String payload) {
        this.doReceiveMessage(endpoint, CitrusSettings.DEFAULT_MESSAGE_TYPE, payload);
    }

    @When(value="^<([^>]+)> receives$")
    public void receiveDefaultPayload(String endpoint, String payload) {
        this.doReceiveMessage(endpoint, CitrusSettings.DEFAULT_MESSAGE_TYPE, payload);
    }

    @When(value="^<([^>]+)> receives ([^\\s\"]+)$")
    public void receivePayload(String endpoint, String type, String payload) {
        this.doReceiveMessage(endpoint, type, payload);
    }

    @Then(value="^<([^>]+)> should receive ([^\\s]+) \"([^\"]*)\"$")
    public void shouldReceive(String endpoint, String type, String payload) {
        this.doReceiveMessage(endpoint, type, payload);
    }

    @Then(value="^<([^>]+)> should receive \"([^\"]*)\"$")
    public void shouldReceiveDefault(String endpoint, String payload) {
        this.doReceiveMessage(endpoint, CitrusSettings.DEFAULT_MESSAGE_TYPE, payload);
    }

    @Then(value="^<([^>]+)> should receive$")
    public void shouldReceiveDefaultPayload(String endpoint, String payload) {
        this.doReceiveMessage(endpoint, CitrusSettings.DEFAULT_MESSAGE_TYPE, payload);
    }

    @Then(value="^<([^>]+)> should receive ([^\\s\"]+)$")
    public void shouldReceivePayload(String endpoint, String type, String payload) {
        this.doReceiveMessage(endpoint, type, payload);
    }

    @And(value="^<([^>]+)> header ([^\\s]+)(?: is |=)\"([^\"]*)\"$")
    public void addHeader(String messageId, String name, String value) {
        if (!this.messages.containsKey(messageId)) {
            throw new CitrusRuntimeException(String.format("Unknown message '%s'", messageId));
        }
        this.messages.get(messageId).setHeader(name, (Object)value);
    }

    @And(value="^<([^>]+)> payload (?:is )?\"([^\"]*)\"$")
    public void addPayload(String messageId, String payload) {
        if (!this.messages.containsKey(messageId)) {
            throw new CitrusRuntimeException(String.format("Unknown message '%s'", messageId));
        }
        this.messages.get(messageId).setPayload((Object)payload);
    }

    @And(value="^<([^>]+)> payload(?: is)?$")
    public void addPayloadMultiline(String messageId, String payload) {
        this.addPayload(messageId, payload);
    }
}

