/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.cucumber.step.runner.http;

import com.consol.citrus.Citrus;
import com.consol.citrus.TestActionBuilder;
import com.consol.citrus.TestCaseRunner;
import com.consol.citrus.annotations.CitrusFramework;
import com.consol.citrus.annotations.CitrusResource;
import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.http.actions.HttpActionBuilder;
import com.consol.citrus.http.actions.HttpClientActionBuilder;
import com.consol.citrus.http.actions.HttpClientRequestActionBuilder;
import com.consol.citrus.http.actions.HttpClientResponseActionBuilder;
import com.consol.citrus.http.actions.HttpServerActionBuilder;
import com.consol.citrus.http.actions.HttpServerRequestActionBuilder;
import com.consol.citrus.http.client.HttpClient;
import com.consol.citrus.http.message.HttpMessage;
import com.consol.citrus.http.server.HttpServer;
import com.consol.citrus.message.Message;
import com.consol.citrus.validation.PathExpressionValidationContext;
import com.consol.citrus.validation.context.ValidationContext;
import com.consol.citrus.validation.json.JsonPathMessageValidationContext;
import com.consol.citrus.validation.xml.XpathMessageValidationContext;
import io.cucumber.java.Before;
import io.cucumber.java.en.Given;
import io.cucumber.java.en.Then;
import io.cucumber.java.en.When;
import java.util.HashMap;
import java.util.Map;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.util.StringUtils;

public class HttpSteps {
    @CitrusResource
    private TestCaseRunner runner;
    @CitrusFramework
    private Citrus citrus;
    protected HttpClient httpClient;
    protected HttpServer httpServer;
    private HttpMessage request;
    private HttpMessage response;
    private Map<String, String> headers = new HashMap<String, String>();
    private Map<String, String> pathValidations = new HashMap<String, String>();
    private String body;
    private String contentType;
    private String url;

    @Before
    public void before() {
        if (this.httpClient == null && (long)this.citrus.getCitrusContext().getReferenceResolver().resolveAll(HttpClient.class).size() == 1L) {
            this.httpClient = (HttpClient)this.citrus.getCitrusContext().getReferenceResolver().resolve(HttpClient.class);
        }
        if (this.httpServer == null && (long)this.citrus.getCitrusContext().getReferenceResolver().resolveAll(HttpServer.class).size() == 1L) {
            this.httpServer = (HttpServer)this.citrus.getCitrusContext().getReferenceResolver().resolve(HttpServer.class);
        }
        this.request = new HttpMessage();
        this.response = new HttpMessage();
        this.headers = new HashMap<String, String>();
        this.pathValidations = new HashMap<String, String>();
    }

    @Given(value="^http-client \"([^\"\\s]+)\"$")
    public void setClient(String id) {
        if (!this.citrus.getCitrusContext().getReferenceResolver().isResolvable(id)) {
            throw new CitrusRuntimeException("Unable to find http client for id: " + id);
        }
        this.httpClient = (HttpClient)this.citrus.getCitrusContext().getReferenceResolver().resolve(id, HttpClient.class);
    }

    @Given(value="^http-server \"([^\"\\s]+)\"$")
    public void setServer(String id) {
        if (!this.citrus.getCitrusContext().getReferenceResolver().isResolvable(id)) {
            throw new CitrusRuntimeException("Unable to find http server for id: " + id);
        }
        this.httpServer = (HttpServer)this.citrus.getCitrusContext().getReferenceResolver().resolve(id, HttpServer.class);
    }

    @Given(value="^URL: ([^\\s]+)$")
    public void setUrl(String url) {
        this.url = url;
    }

    @Given(value="^Path: ([^\\s]+)$")
    public void setRequestPath(String path) {
        this.request.path(path);
        this.request.contextPath(path);
    }

    @Given(value="^Host: (.+)$")
    public void setHost(String host) {
        this.headers.put("Host", host);
    }

    @Given(value="^Accept: (.+)$")
    public void setAccept(String contentType) {
        this.headers.put("Accept", contentType);
    }

    @Given(value="^Accept-Encoding: (.+)$")
    public void setAcceptEncoding(String encoding) {
        this.headers.put("Accept-Encoding", encoding);
    }

    @Given(value="^Content-Type: (.+)$")
    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    @Given(value="^Content-Encoding: (.+)$")
    public void setContentEncoding(String encoding) {
        this.headers.put("Content-Encoding", encoding);
    }

    @Given(value="^(X-[^\\s]+): (.+)$")
    public void addCustomHeader(String name, String value) {
        this.headers.put(name, value);
    }

    @Given(value="^Header ([^\\s]+): (.+)$")
    public void addHeader(String name, String value) {
        this.headers.put(name, value);
    }

    @Given(value="^validate ([^\\s]+) is (.+)$")
    public void addPathValidation(String name, String value) {
        this.pathValidations.put(name, value);
    }

    @Given(value="^(?:Payload):$")
    public void setPayloadMultiline(String payload) {
        this.setPayload(payload);
    }

    @Given(value="^(?:Payload): (.+)$")
    public void setPayload(String payload) {
        this.body = payload;
    }

    @When(value="^(?:http-client )?sends? request$")
    public void sendClientRequestFull(String requestData) {
        this.sendClientRequest(HttpMessage.fromRequestData((String)requestData));
    }

    @Then(value="^(?:http-client )?receives? response$")
    public void receiveClientResponseFull(String responseData) {
        this.receiveClientResponse(HttpMessage.fromResponseData((String)responseData));
    }

    @When(value="^(?:http-server )?receives? request$")
    public void receiveServerRequestFull(String requestData) {
        this.receiveServerRequest(HttpMessage.fromRequestData((String)requestData));
    }

    @Then(value="^(?:http-server )?sends? response$")
    public void sendServerResponseFull(String responseData) {
        this.sendServerResponse(HttpMessage.fromResponseData((String)responseData));
    }

    @When(value="^(?:http-client )?sends? (GET|HEAD|POST|PUT|PATCH|DELETE|OPTIONS|TRACE)$")
    public void sendClientRequest(String method) {
        this.sendClientRequest(method, null);
    }

    @When(value="^(?:http-client )?sends? (GET|HEAD|POST|PUT|PATCH|DELETE|OPTIONS|TRACE) ([^\"\\s]+)$")
    public void sendClientRequest(String method, String path) {
        this.request.method(HttpMethod.valueOf((String)method));
        if (StringUtils.hasText((String)path)) {
            this.request.path(path);
        }
        if (StringUtils.hasText((String)this.body)) {
            this.request.setPayload((Object)this.body);
            this.body = null;
        }
        if (StringUtils.hasText((String)this.contentType)) {
            this.request.contentType(this.contentType);
            this.contentType = null;
        }
        for (Map.Entry<String, String> headerEntry : this.headers.entrySet()) {
            this.request.setHeader(headerEntry.getKey(), (Object)headerEntry.getValue());
        }
        this.headers.clear();
        this.sendClientRequest(this.request);
    }

    protected void sendClientRequest(HttpMessage request) {
        HttpClientActionBuilder.HttpClientSendActionBuilder sendBuilder = HttpActionBuilder.http().client(this.httpClient).send();
        HttpClientRequestActionBuilder requestBuilder = request.getRequestMethod() == null || request.getRequestMethod().equals((Object)HttpMethod.POST) ? sendBuilder.post().message((Message)request) : (request.getRequestMethod().equals((Object)HttpMethod.GET) ? sendBuilder.get().message((Message)request) : (request.getRequestMethod().equals((Object)HttpMethod.PUT) ? sendBuilder.put().message((Message)request) : (request.getRequestMethod().equals((Object)HttpMethod.DELETE) ? sendBuilder.delete().message((Message)request) : (request.getRequestMethod().equals((Object)HttpMethod.HEAD) ? sendBuilder.head().message((Message)request) : (request.getRequestMethod().equals((Object)HttpMethod.TRACE) ? sendBuilder.trace().message((Message)request) : (request.getRequestMethod().equals((Object)HttpMethod.PATCH) ? sendBuilder.patch().message((Message)request) : (request.getRequestMethod().equals((Object)HttpMethod.OPTIONS) ? sendBuilder.options().message((Message)request) : sendBuilder.post().message((Message)request))))))));
        if (StringUtils.hasText((String)this.url)) {
            requestBuilder.uri(this.url);
        }
        this.runner.run((TestActionBuilder)requestBuilder);
    }

    @Then(value="^(?:http-client )?receives? status (\\d+)(?: [^\\s]+)?$")
    public void receiveClientResponse(Integer status) {
        this.response.status(HttpStatus.valueOf((int)status));
        if (StringUtils.hasText((String)this.body)) {
            this.response.setPayload((Object)this.body);
            this.body = null;
        }
        if (StringUtils.hasText((String)this.contentType)) {
            this.response.contentType(this.contentType);
            this.contentType = null;
        }
        for (Map.Entry<String, String> headerEntry : this.headers.entrySet()) {
            this.response.setHeader(headerEntry.getKey(), (Object)headerEntry.getValue());
        }
        this.headers.clear();
        this.receiveClientResponse(this.response);
    }

    protected void receiveClientResponse(HttpMessage response) {
        HttpClientResponseActionBuilder responseBuilder = HttpActionBuilder.http().client(this.httpClient).receive().response(response.getStatusCode()).message((Message)response);
        for (Map.Entry<String, String> pathValidation : this.pathValidations.entrySet()) {
            responseBuilder.validate((ValidationContext.Builder)PathExpressionValidationContext.Builder.pathExpression().expression(pathValidation.getKey(), (Object)pathValidation.getValue()));
        }
        this.pathValidations.clear();
        this.runner.run((TestActionBuilder)responseBuilder);
    }

    @When(value="^(?:http-server )?receives? (GET|HEAD|POST|PUT|PATCH|DELETE|OPTIONS|TRACE)$")
    public void receiveServerRequest(String method) {
        this.receiveServerRequest(method, null);
    }

    @When(value="^(?:http-server )?receives? (GET|HEAD|POST|PUT|PATCH|DELETE|OPTIONS|TRACE) ([^\"\\s]+)$")
    public void receiveServerRequest(String method, String path) {
        this.request.method(HttpMethod.valueOf((String)method));
        if (StringUtils.hasText((String)path)) {
            this.request.path(path);
        }
        if (StringUtils.hasText((String)this.body)) {
            this.request.setPayload((Object)this.body);
            this.body = null;
        }
        if (StringUtils.hasText((String)this.contentType)) {
            this.request.contentType(this.contentType);
            this.contentType = null;
        }
        for (Map.Entry<String, String> headerEntry : this.headers.entrySet()) {
            this.request.setHeader(headerEntry.getKey(), (Object)headerEntry.getValue());
        }
        this.headers.clear();
        this.receiveServerRequest(this.request);
    }

    protected void receiveServerRequest(HttpMessage request) {
        HttpServerActionBuilder.HttpServerReceiveActionBuilder receiveBuilder = HttpActionBuilder.http().server(this.httpServer).receive();
        HttpServerRequestActionBuilder requestBuilder = request.getRequestMethod() == null || request.getRequestMethod().equals((Object)HttpMethod.POST) ? receiveBuilder.post().message((Message)request) : (request.getRequestMethod().equals((Object)HttpMethod.GET) ? receiveBuilder.get().message((Message)request) : (request.getRequestMethod().equals((Object)HttpMethod.PUT) ? receiveBuilder.put().message((Message)request) : (request.getRequestMethod().equals((Object)HttpMethod.DELETE) ? receiveBuilder.delete().message((Message)request) : (request.getRequestMethod().equals((Object)HttpMethod.HEAD) ? receiveBuilder.head().message((Message)request) : (request.getRequestMethod().equals((Object)HttpMethod.TRACE) ? receiveBuilder.trace().message((Message)request) : (request.getRequestMethod().equals((Object)HttpMethod.PATCH) ? receiveBuilder.patch().message((Message)request) : (request.getRequestMethod().equals((Object)HttpMethod.OPTIONS) ? receiveBuilder.options().message((Message)request) : receiveBuilder.post().message((Message)request))))))));
        for (Map.Entry<String, String> pathValidation : this.pathValidations.entrySet()) {
            Object validationContext = JsonPathMessageValidationContext.isJsonPathExpression((String)pathValidation.getKey()) ? JsonPathMessageValidationContext.Builder.jsonPath().expression(pathValidation.getKey(), (Object)pathValidation.getValue()).build() : XpathMessageValidationContext.Builder.xpath().expression(pathValidation.getKey(), (Object)pathValidation.getValue()).build();
            requestBuilder.validate((ValidationContext)validationContext);
        }
        this.pathValidations.clear();
        this.runner.run((TestActionBuilder)requestBuilder);
    }

    @Then(value="^(?:http-server )?sends? status (\\d+)(?: [^\\s]+)?$")
    public void sendServerResponse(Integer status) {
        this.response.status(HttpStatus.valueOf((int)status));
        if (StringUtils.hasText((String)this.body)) {
            this.response.setPayload((Object)this.body);
            this.body = null;
        }
        if (StringUtils.hasText((String)this.contentType)) {
            this.response.contentType(this.contentType);
            this.contentType = null;
        }
        for (Map.Entry<String, String> headerEntry : this.headers.entrySet()) {
            this.response.setHeader(headerEntry.getKey(), (Object)headerEntry.getValue());
        }
        this.headers.clear();
        this.sendServerResponse(this.response);
    }

    protected void sendServerResponse(HttpMessage response) {
        this.runner.run((TestActionBuilder)HttpActionBuilder.http().server(this.httpServer).send().response(response.getStatusCode()).message((Message)response));
    }
}

