/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.cucumber.step.runner.selenium;

import com.consol.citrus.Citrus;
import com.consol.citrus.TestActionBuilder;
import com.consol.citrus.TestCaseRunner;
import com.consol.citrus.annotations.CitrusFramework;
import com.consol.citrus.annotations.CitrusResource;
import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.selenium.actions.FindElementAction;
import com.consol.citrus.selenium.actions.SeleniumActionBuilder;
import com.consol.citrus.selenium.endpoint.SeleniumBrowser;
import com.consol.citrus.selenium.model.PageValidator;
import com.consol.citrus.selenium.model.WebPage;
import com.consol.citrus.variable.VariableUtils;
import io.cucumber.datatable.DataTable;
import io.cucumber.java.Before;
import io.cucumber.java.en.Given;
import io.cucumber.java.en.Then;
import io.cucumber.java.en.When;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.util.StringUtils;

public class SeleniumSteps {
    @CitrusResource
    protected TestCaseRunner runner;
    @CitrusFramework
    protected Citrus citrus;
    private Map<String, WebPage> pages;
    private Map<String, PageValidator<?>> validators;
    protected SeleniumBrowser browser;

    @Before
    public void before() {
        if (this.browser == null && (long)this.citrus.getCitrusContext().getReferenceResolver().resolveAll(SeleniumBrowser.class).size() == 1L) {
            this.browser = (SeleniumBrowser)this.citrus.getCitrusContext().getReferenceResolver().resolve(SeleniumBrowser.class);
        }
        this.pages = new HashMap<String, WebPage>();
        this.validators = new HashMap();
    }

    @Given(value="^(?:selenium )?browser \"([^\"]+)\"$")
    public void setBrowser(String id) {
        if (!this.citrus.getCitrusContext().getReferenceResolver().isResolvable(id)) {
            throw new CitrusRuntimeException("Unable to find selenium browser for id: " + id);
        }
        this.browser = (SeleniumBrowser)this.citrus.getCitrusContext().getReferenceResolver().resolve(id, SeleniumBrowser.class);
    }

    @Given(value="^pages$")
    public void pages(DataTable dataTable) {
        Map variables = dataTable.asMap(String.class, String.class);
        for (Map.Entry entry : variables.entrySet()) {
            this.page((String)entry.getKey(), (String)entry.getValue());
        }
    }

    @Given(value="^page \"([^\"]+)\" ([^\\s]+)$")
    public void page(String id, String type) {
        try {
            this.pages.put(id, (WebPage)Class.forName(type).newInstance());
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new CitrusRuntimeException("Failed to laod page object", (Throwable)e);
        }
    }

    @Given(value="^page validators")
    public void page_validators(DataTable dataTable) {
        Map variables = dataTable.asMap(String.class, String.class);
        for (Map.Entry entry : variables.entrySet()) {
            this.page_validator((String)entry.getKey(), (String)entry.getValue());
        }
    }

    @Given(value="^page validator ([^\\s]+) ([^\\s]+)$")
    public void page_validator(String id, String type) {
        try {
            this.validators.put(id, (PageValidator)Class.forName(type).newInstance());
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new CitrusRuntimeException("Failed to laod page object", (Throwable)e);
        }
    }

    @When(value="^(?:user )?starts? browser$")
    public void start() {
        this.runner.run((TestActionBuilder)SeleniumActionBuilder.selenium().browser(this.browser).start());
    }

    @When(value="^(?:user )?stops? browser$")
    public void stop() {
        this.runner.run((TestActionBuilder)SeleniumActionBuilder.selenium().browser(this.browser).stop());
    }

    @When(value="^(?:user )?navigates? to \"([^\"]+)\"$")
    public void navigate(String url) {
        this.runner.run((TestActionBuilder)SeleniumActionBuilder.selenium().browser(this.browser).navigate(url));
    }

    @When(value="^(?:user )?clicks? (?:element|button|link) with ([^\"]+)=\"([^\"]+)\"$")
    public void click(String property, String value) {
        this.runner.run((TestActionBuilder)SeleniumActionBuilder.selenium().browser(this.browser).click().element(property, value));
    }

    @When(value="^(?:user )?(?:sets?|puts?) text \"([^\"]+)\" to (?:element|input|textfield) with ([^\"]+)=\"([^\"]+)\"$")
    public void setInput(String text, String property, String value) {
        this.runner.run((TestActionBuilder)SeleniumActionBuilder.selenium().browser(this.browser).setInput(text).element(property, value));
    }

    @When(value="^(?:user )?(checks?|unchecks?) checkbox with ([^\"]+)=\"([^\"]+)\"$")
    public void checkInput(String type, String property, String value) {
        this.runner.run((TestActionBuilder)SeleniumActionBuilder.selenium().browser(this.browser).checkInput(type.equals("check") || type.equals("checks")).element(property, value));
    }

    @Then(value="^(?:page )?should (?:display|have) (?:element|button|link|input|textfield|form|heading) with (id|name|class-name|link-text|css-selector|tag-name|xpath)=\"([^\"]+)\"$")
    public void should_display(String property, String value) {
        this.runner.run((TestActionBuilder)SeleniumActionBuilder.selenium().browser(this.browser).find().enabled(true).displayed(true).element(property, value));
    }

    @Then(value="^(?:page )?should (?:display|have) (?:element|button|link|input|textfield|form|heading) with (id|name|class-name|link-text|css-selector|tag-name|xpath)=\"([^\"]+)\" having$")
    public void should_display(String property, String value, DataTable dataTable) {
        Map elementProperties = dataTable.asMap(String.class, String.class);
        FindElementAction.Builder elementBuilder = (FindElementAction.Builder)SeleniumActionBuilder.selenium().browser(this.browser).find().element(property, value);
        for (Map.Entry propertyEntry : elementProperties.entrySet()) {
            String[] keyValue;
            String[] propertyExpressions;
            if (((String)propertyEntry.getKey()).equals("tag-name")) {
                elementBuilder.tagName((String)propertyEntry.getValue());
            }
            if (((String)propertyEntry.getKey()).equals("text")) {
                elementBuilder.text((String)propertyEntry.getValue());
            }
            if (((String)propertyEntry.getKey()).equals("enabled")) {
                elementBuilder.enabled(Boolean.parseBoolean((String)propertyEntry.getValue()));
            }
            if (((String)propertyEntry.getKey()).equals("displayed")) {
                elementBuilder.displayed(Boolean.parseBoolean((String)propertyEntry.getValue()));
            }
            if (((String)propertyEntry.getKey()).equals("styles") || ((String)propertyEntry.getKey()).equals("style")) {
                for (String propertyExpression : propertyExpressions = StringUtils.delimitedListToStringArray((String)((String)propertyEntry.getValue()), (String)";")) {
                    keyValue = propertyExpression.split("=");
                    elementBuilder.style(keyValue[0].trim(), VariableUtils.cutOffDoubleQuotes((String)keyValue[1].trim()));
                }
            }
            if (!((String)propertyEntry.getKey()).equals("attributes") && !((String)propertyEntry.getKey()).equals("attribute")) continue;
            for (String propertyExpression : propertyExpressions = StringUtils.commaDelimitedListToStringArray((String)((String)propertyEntry.getValue()))) {
                keyValue = propertyExpression.split("=");
                elementBuilder.attribute(keyValue[0].trim(), VariableUtils.cutOffDoubleQuotes((String)keyValue[1].trim()));
            }
        }
        this.runner.run((TestActionBuilder)elementBuilder);
    }

    @When(value="^(?:page )?([^\\s]+) performs ([^\\s]+)$")
    public void page_action(String pageId, String method) {
        this.page_action_with_arguments(pageId, method, null);
    }

    @When(value="^(?:page )?([^\\s]+) performs ([^\\s]+) with arguments$")
    public void page_action_with_arguments(String pageId, String method, DataTable dataTable) {
        this.verifyPage(pageId);
        List arguments = new ArrayList();
        if (dataTable != null) {
            arguments = dataTable.asList(String.class);
        }
        this.runner.run((TestActionBuilder)SeleniumActionBuilder.selenium().browser(this.browser).page(this.pages.get(pageId)).execute(method).arguments(arguments));
    }

    @Then(value="^(?:page )?([^\\s]+) should validate$")
    public void page_should_validate(String pageId) {
        this.page_should_validate_with_validator(pageId, null);
    }

    @Then(value="^(?:page )?([^\\s]+) should validate with ([^\\s]+)$")
    public void page_should_validate_with_validator(String pageId, String validatorId) {
        this.verifyPage(pageId);
        PageValidator<?> pageValidator = null;
        if (this.validators.containsKey(validatorId)) {
            pageValidator = this.validators.get(validatorId);
        }
        this.runner.run((TestActionBuilder)SeleniumActionBuilder.selenium().browser(this.browser).page(this.pages.get(pageId)).validator(pageValidator).validate());
    }

    private void verifyPage(String pageId) {
        if (!this.pages.containsKey(pageId)) {
            throw new CitrusRuntimeException(String.format("Unknown page '%s' - please introduce page with type information first", pageId));
        }
    }
}

