/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.cucumber.backend;

import com.consol.citrus.Citrus;
import com.consol.citrus.CitrusInstanceManager;
import com.consol.citrus.DefaultTestCaseRunner;
import com.consol.citrus.TestCaseRunner;
import com.consol.citrus.annotations.CitrusAnnotations;
import com.consol.citrus.context.TestContext;
import io.cucumber.core.backend.ObjectFactory;
import io.cucumber.core.exception.CucumberException;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class CitrusObjectFactory
implements ObjectFactory {
    private TestCaseRunner runner;
    private TestContext context;
    private static CitrusObjectFactory selfReference;
    private final Map<Class<?>, Object> instances = new HashMap();

    public CitrusObjectFactory() {
        selfReference = this;
    }

    public void start() {
        this.context = CitrusInstanceManager.getOrDefault().getCitrusContext().createTestContext();
        this.runner = new DefaultTestCaseRunner(this.context);
    }

    public void stop() {
        this.instances.clear();
    }

    public <T> T getInstance(Class<T> type) {
        if (CitrusObjectFactory.class.isAssignableFrom(type)) {
            return (T)this;
        }
        T instance = type.cast(Optional.ofNullable(this.instances.get(type)).orElseGet(() -> this.createNewInstance(type)));
        CitrusAnnotations.injectAll(instance, (Citrus)CitrusInstanceManager.getOrDefault(), (TestContext)this.context);
        CitrusAnnotations.injectTestRunner(instance, (TestCaseRunner)this.runner);
        return instance;
    }

    private <T> T createNewInstance(Class<T> type) {
        try {
            Constructor<T> constructor = type.getConstructor(new Class[0]);
            T instance = constructor.newInstance(new Object[0]);
            this.instances.put(type, instance);
            return instance;
        }
        catch (NoSuchMethodException e) {
            throw new CucumberException(String.format("%s doesn't have an empty constructor", type), (Throwable)e);
        }
        catch (Exception e) {
            throw new CucumberException(String.format("Failed to instantiate %s", type), (Throwable)e);
        }
    }

    public boolean addClass(Class<?> glueClass) {
        return true;
    }

    public static CitrusObjectFactory instance() throws IllegalAccessException {
        if (selfReference == null) {
            throw new IllegalAccessException("Illegal access to self reference - not available yet");
        }
        return selfReference;
    }
}

