/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.cucumber.message;

import com.consol.citrus.cucumber.message.MessageCreator;
import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.message.Message;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.springframework.util.ReflectionUtils;

public class MessageCreators {
    private List<Object> messageCreators = new ArrayList<Object>();

    public Message createMessage(final String messageName) {
        final Message[] message = new Message[]{null};
        for (final Object messageCreator : this.messageCreators) {
            ReflectionUtils.doWithMethods(messageCreator.getClass(), (ReflectionUtils.MethodCallback)new ReflectionUtils.MethodCallback(){

                public void doWith(Method method) throws IllegalArgumentException, IllegalAccessException {
                    if (method.getAnnotation(MessageCreator.class).value().equals(messageName)) {
                        try {
                            message[0] = (Message)method.invoke(messageCreator, new Object[0]);
                        }
                        catch (InvocationTargetException e) {
                            throw new CitrusRuntimeException("Unsupported message creator method: " + method.getName(), (Throwable)e);
                        }
                    }
                }
            }, (ReflectionUtils.MethodFilter)new ReflectionUtils.MethodFilter(){

                public boolean matches(Method method) {
                    return ((MessageCreator[])method.getAnnotationsByType(MessageCreator.class)).length > 0;
                }
            });
        }
        if (message[0] == null) {
            throw new CitrusRuntimeException("Unable to find message creator for message: " + messageName);
        }
        return message[0];
    }

    public void addType(String type) {
        try {
            this.messageCreators.add(Class.forName(type).newInstance());
        }
        catch (ClassNotFoundException | IllegalAccessException e) {
            throw new CitrusRuntimeException("Unable to access message creator type: " + type, (Throwable)e);
        }
        catch (InstantiationException e) {
            throw new CitrusRuntimeException("Unable to create  message creator instance of type: " + type, (Throwable)e);
        }
    }
}

