/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.cucumber.step.runner.docker;

import com.consol.citrus.Citrus;
import com.consol.citrus.TestActionBuilder;
import com.consol.citrus.TestCaseRunner;
import com.consol.citrus.annotations.CitrusFramework;
import com.consol.citrus.annotations.CitrusResource;
import com.consol.citrus.docker.actions.DockerExecuteAction;
import com.consol.citrus.docker.client.DockerClient;
import com.consol.citrus.exceptions.CitrusRuntimeException;
import io.cucumber.java.Before;
import io.cucumber.java.en.Given;
import io.cucumber.java.en.Then;
import io.cucumber.java.en.When;
import org.springframework.util.Assert;

public class DockerSteps {
    @CitrusResource
    private TestCaseRunner runner;
    @CitrusFramework
    private Citrus citrus;
    protected DockerClient dockerClient;

    @Before
    public void before() {
        if (this.dockerClient == null && (long)this.citrus.getCitrusContext().getReferenceResolver().resolveAll(DockerClient.class).size() == 1L) {
            this.dockerClient = (DockerClient)this.citrus.getCitrusContext().getReferenceResolver().resolve(DockerClient.class);
        }
    }

    @Given(value="^docker-client \"([^\"]+)\"$")
    public void setClient(String id) {
        if (!this.citrus.getCitrusContext().getReferenceResolver().isResolvable(id)) {
            throw new CitrusRuntimeException("Unable to find docker client for id: " + id);
        }
        this.dockerClient = (DockerClient)this.citrus.getCitrusContext().getReferenceResolver().resolve(id, DockerClient.class);
    }

    @When(value="^create container \"([^\"]+)\" from \"([^\"]+)\"$")
    public void createContainer(String containerName, String imageTag) {
        this.runner.when((TestActionBuilder)DockerExecuteAction.Builder.docker().client(this.dockerClient).create(imageTag).name(containerName).validateCommandResult((result, context) -> context.setVariable("citrus_docker_containerId", (Object)result.getId())));
    }

    @When(value="^build image \"([^\"]+)\" from file \"([^\"]+)\"$")
    public void buildImage(String imageTag, String fileName) {
        this.runner.when((TestActionBuilder)DockerExecuteAction.Builder.docker().client(this.dockerClient).buildImage().tag(imageTag).dockerFile(fileName).validateCommandResult((result, context) -> context.setVariable("citrus_docker_imageId", (Object)result.getImageId())));
    }

    @Then(value="^start container \"([^\"]+)\"$")
    public void startContainer(String containerId) {
        this.runner.then((TestActionBuilder)DockerExecuteAction.Builder.docker().client(this.dockerClient).start(containerId).validateCommandResult((result, context) -> Assert.isTrue((!result.isErrorIndicated() ? 1 : 0) != 0, (String)String.format("Failed to start container '%s' - %s", containerId, result.getErrorDetail()))));
    }

    @Then(value="^stop container \"([^\"]+)\"$")
    public void stopContainer(String containerId) {
        this.runner.then((TestActionBuilder)DockerExecuteAction.Builder.docker().client(this.dockerClient).stop(containerId).validateCommandResult((result, context) -> Assert.isTrue((!result.isErrorIndicated() ? 1 : 0) != 0, (String)String.format("Failed to stop container '%s' - %s", containerId, result.getErrorDetail()))));
    }

    @Then(value="^(?:the )?container \"([^\"]+)\" should be running$")
    public void containerIsRunning(String containerId) {
        this.runner.then((TestActionBuilder)DockerExecuteAction.Builder.docker().client(this.dockerClient).inspectContainer(containerId).validateCommandResult((result, context) -> Assert.isTrue((boolean)result.getState().getRunning(), (String)"Failed to validate container state, expected running but was stopped")));
    }

    @Then(value="^(?:the )?container \"([^\"]+)\" should be stopped")
    public void containerIsStopped(String containerId) {
        this.runner.then((TestActionBuilder)DockerExecuteAction.Builder.docker().client(this.dockerClient).inspectContainer(containerId).validateCommandResult((result, context) -> Assert.isTrue((result.getState().getRunning() == false ? 1 : 0) != 0, (String)"Failed to validate container state, expected stopped but was running")));
    }
}

