/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.cucumber;

import com.consol.citrus.TestClass;
import com.consol.citrus.cucumber.CitrusReporter;
import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.main.AbstractTestEngine;
import com.consol.citrus.main.TestRunConfiguration;
import io.cucumber.core.backend.ObjectFactory;
import io.cucumber.core.options.CommandlineOptionsParser;
import io.cucumber.core.options.CucumberOptionsAnnotationParser;
import io.cucumber.core.options.CucumberProperties;
import io.cucumber.core.options.CucumberPropertiesParser;
import io.cucumber.core.options.RuntimeOptions;
import io.cucumber.core.runtime.Runtime;
import io.cucumber.core.snippets.SnippetType;
import io.cucumber.plugin.Plugin;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class CucumberTestEngine
extends AbstractTestEngine {
    private static final Logger LOG = LoggerFactory.getLogger(CucumberTestEngine.class);

    public CucumberTestEngine(TestRunConfiguration configuration) {
        super(configuration);
    }

    public void run() {
        RuntimeOptions annotationOptions;
        RuntimeOptions propertiesFileOptions = new CucumberPropertiesParser().parse(CucumberProperties.fromPropertiesFile()).build();
        if (CollectionUtils.isEmpty((Collection)this.getConfiguration().getTestClasses())) {
            annotationOptions = propertiesFileOptions;
        } else {
            TestClass testClass = (TestClass)this.getConfiguration().getTestClasses().get(0);
            try {
                annotationOptions = new CucumberOptionsAnnotationParser().withOptionsProvider(GenericCucumberOptions::new).parse(Class.forName(testClass.getName())).addDefaultGlueIfAbsent().build(propertiesFileOptions);
            }
            catch (ClassNotFoundException e) {
                throw new CitrusRuntimeException("Unable to find test class in classpath: " + testClass.getName());
            }
        }
        RuntimeOptions environmentOptions = new CucumberPropertiesParser().parse(CucumberProperties.fromEnvironment()).build(annotationOptions);
        RuntimeOptions systemOptions = new CucumberPropertiesParser().parse(CucumberProperties.fromSystemProperties()).build(environmentOptions);
        ArrayList<Object> args = new ArrayList<Object>();
        List packagesToRun = this.getConfiguration().getPackages();
        if (CollectionUtils.isEmpty((Collection)packagesToRun)) {
            LOG.info("Running all tests in project");
        } else if (StringUtils.hasText((String)((String)packagesToRun.get(0)))) {
            LOG.info(String.format("Running tests in package %s", packagesToRun.get(0)));
            args.add("classpath:" + ((String)packagesToRun.get(0)).replaceAll("\\.", "/"));
            args.add("--glue");
            args.add((String)packagesToRun.get(0));
        }
        CommandlineOptionsParser commandlineOptionsParser = new CommandlineOptionsParser((OutputStream)System.out);
        RuntimeOptions runtimeOptions = commandlineOptionsParser.parse(args.toArray(new String[0])).addDefaultGlueIfAbsent().addDefaultFeaturePathIfAbsent().addDefaultSummaryPrinterIfNotDisabled().build(systemOptions);
        Runtime runtime = Runtime.builder().withRuntimeOptions(runtimeOptions).withAdditionalPlugins(new Plugin[]{new CitrusReporter()}).build();
        runtime.run();
    }

    private static class GenericCucumberOptions
    implements CucumberOptionsAnnotationParser.CucumberOptions {
        private final Annotation options;

        public GenericCucumberOptions(Class<?> clazz) {
            this.options = Arrays.stream(clazz.getAnnotations()).filter(annotation -> annotation.annotationType().getSimpleName().equals("CucumberOptions")).findFirst().orElseThrow(() -> new CitrusRuntimeException("Missing CucumberOptions annotation on test class: " + clazz.getName()));
        }

        <T> T getOptionValue(String optionName) {
            try {
                Method method = this.options.annotationType().getDeclaredMethod(optionName, new Class[0]);
                return (T)method.invoke((Object)this.options, new Object[0]);
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                throw new CitrusRuntimeException(String.format("Failed to retrieve Cucumber option %s on annotation type %s", optionName, this.options.annotationType()));
            }
        }

        public boolean dryRun() {
            return (Boolean)this.getOptionValue("dryRun");
        }

        public String[] features() {
            return (String[])this.getOptionValue("features");
        }

        public String[] glue() {
            return (String[])this.getOptionValue("glue");
        }

        public String[] extraGlue() {
            return (String[])this.getOptionValue("extraGlue");
        }

        public String tags() {
            return (String)this.getOptionValue("tags");
        }

        public String[] plugin() {
            return (String[])this.getOptionValue("plugin");
        }

        public boolean publish() {
            return (Boolean)this.getOptionValue("publish");
        }

        public boolean monochrome() {
            return (Boolean)this.getOptionValue("monochrome");
        }

        public String[] name() {
            return (String[])this.getOptionValue("name");
        }

        public SnippetType snippets() {
            return SnippetType.UNDERSCORE;
        }

        public Class<? extends ObjectFactory> objectFactory() {
            Class factoryType = (Class)this.getOptionValue("objectFactory");
            if (factoryType.getSimpleName().equals("NoObjectFactory")) {
                return null;
            }
            return factoryType;
        }
    }
}

