/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.cucumber.backend;

import com.consol.citrus.cucumber.backend.Scenario;
import io.cucumber.core.backend.CucumberBackendException;
import io.cucumber.core.backend.HookDefinition;
import io.cucumber.core.backend.Lookup;
import io.cucumber.core.backend.TestCaseState;
import java.lang.reflect.Method;
import org.springframework.util.ReflectionUtils;

public class CitrusHookDefinition
implements HookDefinition {
    private final Method method;
    private final Lookup lookup;
    private final String tagExpression;
    private final int order;

    public CitrusHookDefinition(Method method, String tagExpression, int order, Lookup lookup) {
        this.method = method;
        this.tagExpression = tagExpression;
        this.order = order;
        this.lookup = lookup;
    }

    public void execute(TestCaseState state) {
        Object[] args = this.method.getParameterTypes().length == 1 ? new Object[]{new Scenario(state)} : new Object[]{};
        try {
            ReflectionUtils.invokeMethod((Method)this.method, (Object)this.lookup.getInstance(this.method.getDeclaringClass()), (Object[])args);
        }
        catch (IllegalArgumentException | IllegalStateException e) {
            throw new CucumberBackendException("Failed to invoke " + this.method, (Throwable)e);
        }
    }

    public String getTagExpression() {
        return this.tagExpression;
    }

    public int getOrder() {
        return this.order;
    }

    public boolean isDefinedAt(StackTraceElement stackTraceElement) {
        return stackTraceElement.getClassName().equals(this.method.getDeclaringClass().getName()) && stackTraceElement.getMethodName().equals(this.method.getName());
    }

    public String getLocation() {
        return this.method.getDeclaringClass().getName() + "#" + this.method.getName();
    }
}

