/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.cucumber;

import com.consol.citrus.Citrus;
import com.consol.citrus.TestCase;
import com.consol.citrus.TestCaseRunner;
import com.consol.citrus.TestResult;
import com.consol.citrus.annotations.CitrusFramework;
import com.consol.citrus.annotations.CitrusResource;
import com.consol.citrus.context.TestContext;
import com.consol.citrus.cucumber.backend.Scenario;
import com.consol.citrus.exceptions.CitrusRuntimeException;

public class CitrusLifecycleHooks {
    @CitrusFramework
    protected Citrus citrus;
    @CitrusResource
    protected TestCaseRunner runner;
    @CitrusResource
    private TestContext context;

    public void before(Scenario scenario) {
        if (this.runner != null) {
            this.runner.name(scenario.getName());
            this.runner.description(scenario.getId());
            this.runner.start();
        }
    }

    public void after(Scenario scenario) {
        if (this.runner != null) {
            TestCase testCase;
            TestResult testResult;
            if (this.context != null && scenario.isFailed() && ((testResult = (testCase = this.runner.getTestCase()).getTestResult()) == null || !testResult.isFailed())) {
                this.runner.getTestCase().setTestResult(TestResult.failed((String)testCase.getName(), (String)testCase.getTestClass().getName(), (Throwable)new CitrusRuntimeException(String.format("Scenario '%s' (%s) status %s", scenario.getName(), scenario.getId(), scenario.getStatus().name()))));
            }
            this.runner.stop();
        }
    }
}

