/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.cucumber.backend.spring;

import com.consol.citrus.Citrus;
import com.consol.citrus.CitrusContext;
import com.consol.citrus.CitrusContextProvider;
import com.consol.citrus.CitrusInstanceManager;
import com.consol.citrus.CitrusSpringContext;
import com.consol.citrus.CitrusSpringContextProvider;
import com.consol.citrus.DefaultTestCaseRunner;
import com.consol.citrus.TestCaseRunner;
import com.consol.citrus.annotations.CitrusAnnotations;
import com.consol.citrus.context.TestContext;
import com.consol.citrus.context.TestContextFactoryBean;
import io.cucumber.core.backend.CucumberBackendException;
import io.cucumber.core.backend.ObjectFactory;
import io.cucumber.spring.SpringFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;

public class CitrusSpringObjectFactory
implements ObjectFactory {
    private static final Logger logger = LoggerFactory.getLogger(CitrusSpringObjectFactory.class);
    private TestCaseRunner runner;
    private TestContext context;
    private TestContextFactoryBean testContextFactory;
    private static CitrusSpringObjectFactory selfReference;
    private final SpringFactory delegate = new SpringFactory();

    public CitrusSpringObjectFactory() {
        selfReference = this;
    }

    public void start() {
        this.delegate.start();
        this.context = this.createTestContext();
        this.runner = new DefaultTestCaseRunner(this.context);
    }

    public void stop() {
        this.delegate.stop();
    }

    public <T> T getInstance(Class<T> type) {
        if (TestContext.class.isAssignableFrom(type)) {
            return (T)this.context;
        }
        if (CitrusSpringObjectFactory.class.isAssignableFrom(type)) {
            return (T)this;
        }
        Object instance = this.delegate.getInstance(type);
        CitrusAnnotations.injectAll((Object)instance, (Citrus)CitrusInstanceManager.getOrDefault(), (TestContext)this.context);
        CitrusAnnotations.injectTestRunner((Object)instance, (TestCaseRunner)this.runner);
        return (T)instance;
    }

    private TestContext createTestContext() {
        try {
            TestContextFactoryBean testContextFactoryBean = (TestContextFactoryBean)this.delegate.getInstance(TestContextFactoryBean.class);
            if (this.testContextFactory == null || !this.testContextFactory.equals(testContextFactoryBean)) {
                this.testContextFactory = testContextFactoryBean;
                this.initializeCitrus(this.testContextFactory.getApplicationContext());
            }
            return this.testContextFactory.getObject();
        }
        catch (CucumberBackendException e) {
            logger.warn("Failed to get proper TestContext from Cucumber Spring application context: " + e.getMessage());
            return CitrusInstanceManager.getOrDefault().getCitrusContext().createTestContext();
        }
    }

    private void initializeCitrus(ApplicationContext applicationContext) {
        if (CitrusInstanceManager.hasInstance()) {
            CitrusContext citrusContext = CitrusInstanceManager.getOrDefault().getCitrusContext();
            if (citrusContext instanceof CitrusSpringContext && !((CitrusSpringContext)citrusContext).getApplicationContext().equals(applicationContext)) {
                logger.warn("Citrus instance has already been initialized - creating new instance and shutting down current instance");
                citrusContext.close();
            } else {
                return;
            }
        }
        Citrus.newInstance((CitrusContextProvider)new CitrusSpringContextProvider(applicationContext));
    }

    public boolean addClass(Class<?> glueClass) {
        return this.delegate.addClass(glueClass);
    }

    public static CitrusSpringObjectFactory instance() throws IllegalAccessException {
        if (selfReference == null) {
            throw new IllegalAccessException("Illegal access to self reference - not available yet");
        }
        return selfReference;
    }
}

