/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.db.agent;

import com.consol.citrus.db.agent.JdbcAgentJar;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Path;
import java.util.List;

public class ClassLoaderUtils {
    private static ClassLoaderUtils instance;
    private final JdbcAgentJar agentJar;

    private ClassLoaderUtils(JdbcAgentJar agentJar) {
        this.agentJar = agentJar;
    }

    public static synchronized ClassLoaderUtils getInstance() {
        if (instance == null) {
            instance = new ClassLoaderUtils(JdbcAgentJar.extract());
        }
        return instance;
    }

    public synchronized ClassLoader currentClassLoader() {
        return new URLClassLoader(ClassLoaderUtils.pathsToURLs(this.agentJar.getJars()), Thread.currentThread().getContextClassLoader());
    }

    private static URL[] pathsToURLs(List<Path> paths) {
        try {
            URL[] result = new URL[paths.size()];
            for (int i = 0; i < paths.size(); ++i) {
                result[i] = paths.get(i).toUri().toURL();
            }
            return result;
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }
}

