/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.db.agent;

import com.consol.citrus.db.agent.JdbcDriverAgent;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.URISyntaxException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.security.CodeSource;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.function.Predicate;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class JdbcAgentJar {
    private final List<Path> jars;

    private JdbcAgentJar(List<Path> jars) {
        this.jars = Collections.unmodifiableList(jars);
    }

    List<Path> getJars() {
        return this.jars;
    }

    static JdbcAgentJar extract() {
        List<Path> extractedJars;
        Path driverJar = JdbcAgentJar.findAgentJar();
        try {
            Path tmpDir = Files.createTempDirectory("citrus-db-agent-", new FileAttribute[0]);
            tmpDir.toFile().deleteOnExit();
            extractedJars = JdbcAgentJar.unzip(driverJar, tmpDir, entry -> entry.getName().endsWith(".jar"));
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to load citrus-db-agent.jar: " + e.getMessage(), e);
        }
        ArrayList<Path> sharedJars = new ArrayList<Path>(extractedJars);
        return new JdbcAgentJar(sharedJars);
    }

    private static List<Path> unzip(Path jarFile, Path destDir, Predicate<JarEntry> filter) throws IOException {
        ArrayList<Path> result = new ArrayList<Path>();
        try (JarFile agentJar = new JarFile(jarFile.toFile());){
            Enumeration<JarEntry> jarEntries = agentJar.entries();
            while (jarEntries.hasMoreElements()) {
                JarEntry jarEntry = jarEntries.nextElement();
                if (!filter.test(jarEntry)) continue;
                Path destFile = destDir.resolve(jarEntry.getName());
                if (!destFile.getParent().toFile().exists() && !destFile.getParent().toFile().mkdirs()) {
                    throw new IOException("Failed to make directory: " + destFile.getParent());
                }
                Files.copy(agentJar.getInputStream(jarEntry), destFile, new CopyOption[0]);
                result.add(destFile);
            }
        }
        return result;
    }

    private static Path findAgentJar() {
        CodeSource cs = JdbcDriverAgent.class.getProtectionDomain().getCodeSource();
        if (cs != null) {
            return JdbcAgentJar.findAgentJarFromCodeSource(cs);
        }
        return JdbcAgentJar.findAgentJarFromCmdline(ManagementFactory.getRuntimeMXBean().getInputArguments());
    }

    private static Path findAgentJarFromCodeSource(CodeSource cs) {
        try {
            return Paths.get(cs.getLocation().toURI());
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Failed to load citrus-db-agent.jar from " + cs.getLocation() + ": " + e.getMessage(), e);
        }
    }

    static Path findAgentJarFromCmdline(List<String> cmdlineArgs) {
        Pattern p = Pattern.compile("^-javaagent:(.*citrus-db-agent([^/]*).jar)(=.*)?$");
        for (String arg : cmdlineArgs) {
            Matcher m = p.matcher(arg);
            if (!m.matches()) continue;
            return Paths.get(m.group(1), new String[0]);
        }
        throw new RuntimeException("Failed to locate citrus-db-agent.jar file.");
    }
}

