/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.db.driver;

import com.consol.citrus.db.driver.JdbcCallableStatement;
import com.consol.citrus.db.driver.JdbcDatabaseMetaData;
import com.consol.citrus.db.driver.JdbcPreparedStatement;
import com.consol.citrus.db.driver.JdbcStatement;
import java.io.IOException;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.client.utils.HttpClientUtils;
import org.apache.http.entity.StringEntity;
import org.apache.http.util.EntityUtils;

public class JdbcConnection
implements Connection {
    private final HttpClient httpClient;
    private final String serverUrl;
    private boolean closed = false;

    JdbcConnection(HttpClient httpClient, String serverUrl) {
        this.httpClient = httpClient;
        this.serverUrl = serverUrl;
    }

    @Override
    public Statement createStatement() throws SQLException {
        JdbcStatement jdbcStatement;
        HttpResponse response = null;
        try {
            response = this.httpClient.execute(RequestBuilder.get((String)(this.serverUrl + "/statement")).build());
            if (200 != response.getStatusLine().getStatusCode()) {
                throw new SQLException("Failed to create statement: " + EntityUtils.toString((HttpEntity)response.getEntity()));
            }
            jdbcStatement = new JdbcStatement(this.httpClient, this.serverUrl, this);
        }
        catch (IOException e) {
            try {
                throw new SQLException(e);
            }
            catch (Throwable throwable) {
                HttpClientUtils.closeQuietly(response);
                throw throwable;
            }
        }
        HttpClientUtils.closeQuietly((HttpResponse)response);
        return jdbcStatement;
    }

    @Override
    public void close() throws SQLException {
        HttpResponse response = null;
        try {
            response = this.httpClient.execute(RequestBuilder.delete((String)(this.serverUrl + "/connection")).build());
            if (200 != response.getStatusLine().getStatusCode()) {
                throw new SQLException("Failed to close connection: " + EntityUtils.toString((HttpEntity)response.getEntity()));
            }
            this.closed = true;
        }
        catch (IOException e) {
            try {
                throw new SQLException(e);
            }
            catch (Throwable throwable) {
                this.closed = true;
                HttpClientUtils.closeQuietly(response);
                throw throwable;
            }
        }
        HttpClientUtils.closeQuietly((HttpResponse)response);
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        throw new SQLException("Not supported JDBC connection function 'nativeSQL'");
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        HttpResponse response = null;
        try {
            HttpUriRequest request = RequestBuilder.post((String)(this.serverUrl + "/connection/transaction")).setEntity((HttpEntity)new StringEntity(String.valueOf(!autoCommit))).build();
            response = this.httpClient.execute(request);
            if (200 != response.getStatusLine().getStatusCode()) {
                throw new SQLException("Failed to transmit auto commit value: " + EntityUtils.toString((HttpEntity)response.getEntity()));
            }
        }
        catch (IOException e) {
            try {
                throw new SQLException(e);
            }
            catch (Throwable throwable) {
                HttpClientUtils.closeQuietly(response);
                throw throwable;
            }
        }
        HttpClientUtils.closeQuietly((HttpResponse)response);
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        boolean bl;
        HttpResponse response = null;
        try {
            response = this.httpClient.execute(RequestBuilder.get((String)(this.serverUrl + "/connection/transaction")).build());
            if (200 != response.getStatusLine().getStatusCode()) {
                throw new SQLException("Failed to get auto commit value: " + EntityUtils.toString((HttpEntity)response.getEntity()));
            }
            bl = Boolean.valueOf(EntityUtils.toString((HttpEntity)response.getEntity())) == false;
        }
        catch (IOException e) {
            try {
                throw new SQLException(e);
            }
            catch (Throwable throwable) {
                HttpClientUtils.closeQuietly(response);
                throw throwable;
            }
        }
        HttpClientUtils.closeQuietly((HttpResponse)response);
        return bl;
    }

    @Override
    public void commit() throws SQLException {
        HttpResponse response = null;
        try {
            response = this.httpClient.execute(RequestBuilder.put((String)(this.serverUrl + "/connection/transaction")).build());
            if (200 != response.getStatusLine().getStatusCode()) {
                throw new SQLException("Failed to commit statements: " + EntityUtils.toString((HttpEntity)response.getEntity()));
            }
        }
        catch (IOException e) {
            try {
                throw new SQLException(e);
            }
            catch (Throwable throwable) {
                HttpClientUtils.closeQuietly(response);
                throw throwable;
            }
        }
        HttpClientUtils.closeQuietly((HttpResponse)response);
    }

    @Override
    public void rollback() throws SQLException {
        HttpResponse response = null;
        try {
            response = this.httpClient.execute(RequestBuilder.delete((String)(this.serverUrl + "/connection/transaction")).build());
            if (200 != response.getStatusLine().getStatusCode()) {
                throw new SQLException("Failed to rollback database: " + EntityUtils.toString((HttpEntity)response.getEntity()));
            }
        }
        catch (IOException e) {
            try {
                throw new SQLException(e);
            }
            catch (Throwable throwable) {
                HttpClientUtils.closeQuietly(response);
                throw throwable;
            }
        }
        HttpClientUtils.closeQuietly((HttpResponse)response);
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.closed;
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        return new JdbcDatabaseMetaData();
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        return false;
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
    }

    @Override
    public String getCatalog() throws SQLException {
        throw new SQLException("Not supported JDBC connection function 'getCatalog'");
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        throw new SQLException("Not supported JDBC connection function 'getTransactionIsolation'");
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return null;
    }

    @Override
    public void clearWarnings() throws SQLException {
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        JdbcPreparedStatement jdbcPreparedStatement;
        HttpResponse response = null;
        try {
            response = this.httpClient.execute(RequestBuilder.post((String)(this.serverUrl + "/preparedStatement")).setEntity((HttpEntity)new StringEntity(sql)).build());
            if (200 != response.getStatusLine().getStatusCode()) {
                throw new SQLException("Failed to create prepared statement: " + EntityUtils.toString((HttpEntity)response.getEntity()));
            }
            jdbcPreparedStatement = new JdbcPreparedStatement(this.httpClient, sql, this.serverUrl, this);
        }
        catch (IOException e) {
            try {
                throw new SQLException(e);
            }
            catch (Throwable throwable) {
                HttpClientUtils.closeQuietly(response);
                throw throwable;
            }
        }
        HttpClientUtils.closeQuietly((HttpResponse)response);
        return jdbcPreparedStatement;
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        JdbcCallableStatement jdbcCallableStatement;
        HttpResponse response = null;
        try {
            response = this.httpClient.execute(RequestBuilder.post((String)(this.serverUrl + "/callableStatement")).setEntity((HttpEntity)new StringEntity(sql)).build());
            if (200 != response.getStatusLine().getStatusCode()) {
                throw new SQLException("Failed to create prepare call: " + EntityUtils.toString((HttpEntity)response.getEntity()));
            }
            jdbcCallableStatement = new JdbcCallableStatement(this.httpClient, sql, this.serverUrl, this);
        }
        catch (IOException e) {
            try {
                throw new SQLException(e);
            }
            catch (Throwable throwable) {
                HttpClientUtils.closeQuietly(response);
                throw throwable;
            }
        }
        HttpClientUtils.closeQuietly((HttpResponse)response);
        return jdbcCallableStatement;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.prepareStatement(sql);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        throw new SQLException("Not supported JDBC connection function 'prepareCall'");
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.createStatement();
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        throw new SQLException("Not supported JDBC connection function 'getTypeMap'");
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
    }

    @Override
    public int getHoldability() throws SQLException {
        throw new SQLException("Not supported JDBC connection function 'getHoldability'");
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        throw new SQLException("Not supported JDBC connection function 'setSavepoint'");
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        throw new SQLException("Not supported JDBC connection function 'setSavepoint'");
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return this.createStatement();
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return this.prepareStatement(sql);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        throw new SQLException("Not supported JDBC connection function 'prepareCall'");
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        return this.prepareStatement(sql);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        return this.prepareStatement(sql);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        return this.prepareStatement(sql);
    }

    @Override
    public Clob createClob() throws SQLException {
        throw new SQLException("Not supported JDBC connection function 'createClob'");
    }

    @Override
    public Blob createBlob() throws SQLException {
        throw new SQLException("Not supported JDBC connection function 'createBlob'");
    }

    @Override
    public NClob createNClob() throws SQLException {
        throw new SQLException("Not supported JDBC connection function 'createNClob'");
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        throw new SQLException("Not supported JDBC connection function 'createSQLXML'");
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        return true;
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        throw new SQLException("Not supported JDBC connection function 'getClientInfo'");
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        throw new SQLException("Not supported JDBC connection function 'getClientInfo'");
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        throw new SQLException("Not supported JDBC connection function 'createArrayOf'");
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        throw new SQLException("Not supported JDBC connection function 'createStruct'");
    }

    @Override
    public void setSchema(String schema) throws SQLException {
    }

    @Override
    public String getSchema() throws SQLException {
        throw new SQLException("Not supported JDBC connection function 'getSchema'");
    }

    @Override
    public void abort(Executor executor) throws SQLException {
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        throw new SQLException("Not supported JDBC connection function 'getNetworkTimeout'");
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new SQLException("Not supported JDBC connection function 'unwrap'");
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return false;
    }
}

