/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.db.driver;

import com.consol.citrus.db.driver.JdbcConnection;
import java.net.URI;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Comparator;
import java.util.Optional;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.client.utils.HttpClientUtils;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;

public class JdbcDriver
implements Driver {
    private final HttpClient httpClient;
    private String serverUrl;
    private static int timeout = 5000;
    private int defaultPort = 4567;
    private String[] acceptUrlPatterns = new String[]{"jdbc:citrus:.*"};
    public static final String SERVER_URL_PROPERTY = "citrus.db.server.url";
    private static final String SERVER_URL_ENV = "CITRUS_DB_SERVER_URL";
    public static final String ACCEPT_URL_PATTERNS_PROPERTY = "citrus.db.server.accept.url.pattern";
    private static final String ACCEPT_URL_PATTERNS_ENV = "CITRUS_DB_SERVER_ACCEPT_URL_PATTERN";
    public static final String PORT_PROPERTY = "citrus.db.server.port";
    private static final String PORT_ENV = "CITRUS_DB_SERVER_PORT";
    private static final String[] URL_PREFIX_SET = new String[]{"jdbc:citrus:", "jdbc:weblogic:", "jdbc:microsoft:", "jdbc:oracle:oci:", "jdbc:oracle:oci8:", "jdbc:oracle:thin:", "jdbc:sybase:Tds:", "jdbc:inetdae:", "jdbc:"};
    public static final int MAJOR = 0;
    public static final int MINOR = 1;
    public static final int PATCH = 3;
    public static final JdbcDriver driverInstance = new JdbcDriver();

    public JdbcDriver() {
        this((HttpClient)HttpClients.custom().setDefaultRequestConfig(RequestConfig.copy((RequestConfig)RequestConfig.DEFAULT).setConnectionRequestTimeout(timeout).setConnectTimeout(timeout).setSocketTimeout(timeout).build()).build());
    }

    public JdbcDriver(HttpClient httpClient) {
        this.httpClient = httpClient;
        this.defaultPort = Integer.valueOf(System.getProperty(PORT_PROPERTY, System.getenv(PORT_ENV) != null ? System.getenv(PORT_ENV) : String.valueOf(this.defaultPort)));
        this.serverUrl = System.getProperty(SERVER_URL_PROPERTY, System.getenv(SERVER_URL_ENV) != null ? System.getenv(SERVER_URL_ENV) : this.serverUrl);
        String acceptUrlPatternString = System.getProperty(ACCEPT_URL_PATTERNS_PROPERTY, System.getenv(ACCEPT_URL_PATTERNS_ENV) != null ? System.getenv(ACCEPT_URL_PATTERNS_ENV) : "jdbc:citrus:.*");
        this.acceptUrlPatterns = acceptUrlPatternString.contains(",") ? acceptUrlPatternString.split(",") : new String[]{acceptUrlPatternString};
    }

    @Override
    public Connection connect(String url, Properties info) throws SQLException {
        JdbcConnection connection = null;
        if (this.acceptsURL(url)) {
            try {
                URI uri = new URI(this.getServerUri(url));
                if (this.serverUrl == null || this.serverUrl.length() == 0) {
                    this.serverUrl = "http://" + Optional.ofNullable(uri.getHost()).orElse("localhost") + (uri.getPort() > 0 ? ":" + uri.getPort() : ":" + this.defaultPort);
                }
                this.connectRemote(this.serverUrl, this.getDatabaseName(uri), info);
                connection = new JdbcConnection(this.httpClient, this.serverUrl);
            }
            catch (Exception ex) {
                throw new SQLException(ex.getMessage(), ex);
            }
        }
        return connection;
    }

    private void connectRemote(String serverUrl, String databaseName, Properties info) throws SQLException {
        HttpResponse response = null;
        try {
            HttpUriRequest uriRequest = RequestBuilder.get((String)(serverUrl + "/connection")).addParameter("database", databaseName).addParameters(this.convertProperties(info)).build();
            response = this.httpClient.execute(uriRequest);
            if (200 != response.getStatusLine().getStatusCode()) {
                throw new SQLException("Failed to connect to server: " + EntityUtils.toString((HttpEntity)response.getEntity()));
            }
        }
        catch (Exception ex) {
            try {
                throw new SQLException(ex);
            }
            catch (Throwable throwable) {
                HttpClientUtils.closeQuietly(response);
                throw throwable;
            }
        }
        HttpClientUtils.closeQuietly((HttpResponse)response);
    }

    @Override
    public boolean acceptsURL(String url) throws SQLException {
        return Stream.of(this.acceptUrlPatterns).map(Pattern::compile).anyMatch(pattern -> pattern.matcher(url).matches());
    }

    private NameValuePair[] convertProperties(Properties properties) {
        return properties.entrySet().stream().map(entry -> new BasicNameValuePair(entry.getKey().toString(), entry.getValue() != null ? entry.getValue().toString() : "")).sorted(Comparator.comparingInt(BasicNameValuePair::hashCode)).collect(Collectors.toList()).toArray(new NameValuePair[properties.size()]);
    }

    private String getDatabaseName(URI uri) {
        String resourcePath = uri.getSchemeSpecificPart();
        if (resourcePath.startsWith("//")) {
            resourcePath = resourcePath.substring(2);
        }
        if (resourcePath.contains("?database=")) {
            return resourcePath.substring(resourcePath.indexOf("?database=") + "?database=".length());
        }
        if (resourcePath.contains("/jdbc:cloudscape:")) {
            return resourcePath.substring(resourcePath.indexOf("/jdbc:cloudscape:") + "/jdbc:cloudscape:".length());
        }
        if (resourcePath.contains("/")) {
            return resourcePath.substring(resourcePath.lastIndexOf(47) + 1);
        }
        return "";
    }

    private String getServerUri(String connectionString) {
        String[] tokens;
        String url = connectionString.substring(Stream.of(URL_PREFIX_SET).filter(connectionString::startsWith).findFirst().orElse("").length());
        String localhost = "localhost/";
        if (url.startsWith("@")) {
            tokens = url.substring(1).split(":");
            url = tokens.length > 2 ? tokens[0] + ":" + tokens[1] + "/" + tokens[2] : (tokens.length > 1 ? tokens[0] + "/" + tokens[1] : localhost + tokens[0]);
        }
        if (url.startsWith("mssqlserver4:")) {
            tokens = url.substring("mssqlserver4:".length()).split("@");
            url = tokens[1] + "/" + tokens[0];
        } else if (url.startsWith("odbc:")) {
            url = localhost + url.substring("odbc:".length());
        } else if (url.startsWith("idb:")) {
            url = localhost + url.substring("idb:".length());
        } else if (url.startsWith("HypersonicSQL:")) {
            url = localhost + url.substring("HypersonicSQL:".length());
        } else if (url.startsWith("cloudscape:")) {
            url = localhost + url.substring("cloudscape:".length());
        } else if (url.startsWith("hsqldb:") && !url.contains("://")) {
            url = localhost + url.substring("hsqldb:".length());
        }
        if (!url.contains("://")) {
            url = "http://" + url;
        }
        if (url.contains(";DatabaseName=")) {
            url = url.replace(";DatabaseName=", "/");
        }
        return url;
    }

    @Override
    public int getMajorVersion() {
        return 0;
    }

    @Override
    public int getMinorVersion() {
        return 1;
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties loginProps) throws SQLException {
        return new DriverPropertyInfo[0];
    }

    @Override
    public boolean jdbcCompliant() {
        return false;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return Logger.getGlobal();
    }

    public String getServerUrl() {
        return this.serverUrl;
    }

    public void setServerUrl(String serverUrl) {
        this.serverUrl = serverUrl;
    }

    static {
        try {
            DriverManager.registerDriver(driverInstance);
        }
        catch (Exception e) {
            Logger.getLogger(JdbcDriver.class.getName()).log(Level.WARNING, "Error registering jdbc driver: " + e.getMessage(), e);
        }
    }
}

