/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.db.driver;

import com.consol.citrus.db.driver.JdbcResultSetMetaData;
import com.consol.citrus.db.driver.JdbcStatement;
import com.consol.citrus.db.driver.data.Row;
import com.consol.citrus.db.driver.dataset.DataSet;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;

public class JdbcResultSet
implements ResultSet {
    private final DataSet dataSet;
    private final JdbcStatement statement;
    private Row row;

    public JdbcResultSet(DataSet dataSet, JdbcStatement statement) throws SQLException {
        this.dataSet = dataSet;
        this.statement = statement;
    }

    @Override
    public boolean next() throws SQLException {
        try {
            this.row = this.dataSet.getNextRow();
        }
        catch (SQLException ex) {
            throw ex;
        }
        catch (Exception ex) {
            return false;
        }
        return this.row != null;
    }

    @Override
    public void close() throws SQLException {
        this.dataSet.close();
    }

    private <T> T convert(Object value, Class<T> type) throws SQLException {
        if (value == null) {
            return null;
        }
        if (type.isInstance(value)) {
            return type.cast(value);
        }
        if (String.class.isAssignableFrom(type)) {
            return (T)value.toString();
        }
        if (Byte.class.isAssignableFrom(type)) {
            return (T)Byte.valueOf(value.toString());
        }
        if (Boolean.class.isAssignableFrom(type)) {
            return (T)Boolean.valueOf(value.toString());
        }
        if (Short.class.isAssignableFrom(type)) {
            return (T)Short.valueOf(value.toString());
        }
        if (Integer.class.isAssignableFrom(type)) {
            return (T)Integer.valueOf(value.toString());
        }
        if (Long.class.isAssignableFrom(type)) {
            return (T)Long.valueOf(value.toString());
        }
        if (Double.class.isAssignableFrom(type)) {
            return (T)Double.valueOf(value.toString());
        }
        if (Float.class.isAssignableFrom(type)) {
            return (T)Float.valueOf(value.toString());
        }
        if (Timestamp.class.isAssignableFrom(type)) {
            return (T)Timestamp.valueOf(value.toString());
        }
        if (Time.class.isAssignableFrom(type)) {
            return (T)Time.valueOf(value.toString());
        }
        if (Date.class.isAssignableFrom(type)) {
            return (T)Date.valueOf(value.toString());
        }
        throw new SQLException(String.format("Missing conversion strategy for type %s", type));
    }

    @Override
    public String getString(int columnIndex) throws SQLException {
        return this.convert(this.row.getValue(columnIndex - 1), String.class);
    }

    @Override
    public String getString(String columnName) throws SQLException {
        return this.convert(this.row.getValue(columnName), String.class);
    }

    @Override
    public float getFloat(int columnIndex) throws SQLException {
        if (this.row.getValue(columnIndex - 1) == null) {
            return 0.0f;
        }
        return this.convert(this.row.getValue(columnIndex - 1), Float.class).floatValue();
    }

    @Override
    public float getFloat(String columnName) throws SQLException {
        if (this.row.getValue(columnName) == null) {
            return 0.0f;
        }
        return this.convert(this.row.getValue(columnName), Float.class).floatValue();
    }

    @Override
    public int getInt(int columnIndex) throws SQLException {
        if (this.row.getValue(columnIndex - 1) == null) {
            return 0;
        }
        return this.convert(this.row.getValue(columnIndex - 1), Integer.class);
    }

    @Override
    public int getInt(String columnName) throws SQLException {
        if (this.row.getValue(columnName) == null) {
            return 0;
        }
        return this.convert(this.row.getValue(columnName), Integer.class);
    }

    @Override
    public boolean getBoolean(int columnIndex) throws SQLException {
        if (this.row.getValue(columnIndex - 1) == null) {
            return false;
        }
        return this.convert(this.row.getValue(columnIndex - 1), Boolean.class);
    }

    @Override
    public byte getByte(int columnIndex) throws SQLException {
        if (this.row.getValue(columnIndex - 1) == null) {
            return 0;
        }
        return this.convert(this.row.getValue(columnIndex - 1), Byte.class);
    }

    @Override
    public short getShort(int columnIndex) throws SQLException {
        if (this.row.getValue(columnIndex - 1) == null) {
            return 0;
        }
        return this.convert(this.row.getValue(columnIndex - 1), Short.class);
    }

    @Override
    public long getLong(int columnIndex) throws SQLException {
        if (this.row.getValue(columnIndex - 1) == null) {
            return 0L;
        }
        return this.convert(this.row.getValue(columnIndex - 1), Long.class);
    }

    @Override
    public double getDouble(int columnIndex) throws SQLException {
        if (this.row.getValue(columnIndex - 1) == null) {
            return 0.0;
        }
        return this.convert(this.row.getValue(columnIndex - 1), Double.class);
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        throw new SQLException("Not supported JDBC result set function 'getBigDecimal'");
    }

    @Override
    public byte[] getBytes(int columnIndex) throws SQLException {
        if (this.row.getValue(columnIndex - 1) == null) {
            return null;
        }
        return this.convert(this.row.getValue(columnIndex - 1), String.class).getBytes();
    }

    @Override
    public Date getDate(int columnIndex) throws SQLException {
        if (this.row.getValue(columnIndex - 1) == null) {
            return null;
        }
        return this.convert(this.row.getValue(columnIndex - 1), Date.class);
    }

    @Override
    public Time getTime(int columnIndex) throws SQLException {
        if (this.row.getValue(columnIndex - 1) == null) {
            return null;
        }
        return this.convert(this.row.getValue(columnIndex - 1), Time.class);
    }

    @Override
    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        if (this.row.getValue(columnIndex - 1) == null) {
            return null;
        }
        return this.convert(this.row.getValue(columnIndex - 1), Timestamp.class);
    }

    @Override
    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        if (this.row.getValue(columnIndex - 1) == null) {
            return null;
        }
        byte[] byteArray = this.convert(this.row.getValue(columnIndex - 1), String.class).getBytes();
        return new ByteArrayInputStream(byteArray);
    }

    @Override
    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        if (this.row.getValue(columnIndex - 1) == null) {
            return null;
        }
        byte[] byteArray = this.convert(this.row.getValue(columnIndex - 1), String.class).getBytes();
        return new ByteArrayInputStream(byteArray);
    }

    @Override
    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        if (this.row.getValue(columnIndex - 1) == null) {
            return null;
        }
        byte[] byteArray = this.convert(this.row.getValue(columnIndex - 1), String.class).getBytes();
        return new ByteArrayInputStream(byteArray);
    }

    @Override
    public Object getObject(int columnIndex) throws SQLException {
        return this.row.getValue(columnIndex - 1);
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        if (this.row.getValue(columnIndex - 1) == null) {
            return null;
        }
        Long bigdObj = this.convert(this.row.getValue(columnIndex - 1), Long.class);
        return BigDecimal.valueOf(bigdObj);
    }

    @Override
    public boolean getBoolean(String columnName) throws SQLException {
        if (this.row.getValue(columnName) == null) {
            return false;
        }
        return this.convert(this.row.getValue(columnName), Boolean.class);
    }

    @Override
    public byte getByte(String columnName) throws SQLException {
        if (this.row.getValue(columnName) == null) {
            return 0;
        }
        return this.convert(this.row.getValue(columnName), Byte.class);
    }

    @Override
    public short getShort(String columnName) throws SQLException {
        if (this.row.getValue(columnName) == null) {
            return 0;
        }
        return this.convert(this.row.getValue(columnName), Short.class);
    }

    @Override
    public long getLong(String columnName) throws SQLException {
        if (this.row.getValue(columnName) == null) {
            return 0L;
        }
        return this.convert(this.row.getValue(columnName), Long.class);
    }

    @Override
    public double getDouble(String columnName) throws SQLException {
        if (this.row.getValue(columnName) == null) {
            return 0.0;
        }
        return this.convert(this.row.getValue(columnName), Double.class);
    }

    @Override
    public BigDecimal getBigDecimal(String columnName, int scale) throws SQLException {
        throw new SQLException("Not supported JDBC result set function 'getBigDecimal'");
    }

    @Override
    public byte[] getBytes(String columnName) throws SQLException {
        if (this.row.getValue(columnName) == null) {
            return null;
        }
        return this.convert(this.row.getValue(columnName), String.class).getBytes();
    }

    @Override
    public Date getDate(String columnName) throws SQLException {
        if (this.row.getValue(columnName) == null) {
            return null;
        }
        return this.convert(this.row.getValue(columnName), Date.class);
    }

    @Override
    public Time getTime(String columnName) throws SQLException {
        if (this.row.getValue(columnName) == null) {
            return null;
        }
        return this.convert(this.row.getValue(columnName), Time.class);
    }

    @Override
    public Timestamp getTimestamp(String columnName) throws SQLException {
        if (this.row.getValue(columnName) == null) {
            return null;
        }
        return this.convert(this.row.getValue(columnName), Timestamp.class);
    }

    @Override
    public Object getObject(String columnName) throws SQLException {
        return this.row.getValue(columnName);
    }

    @Override
    public BigDecimal getBigDecimal(String columnName) throws SQLException {
        if (this.row.getValue(columnName) == null) {
            return null;
        }
        Long bigdObj = this.convert(this.row.getValue(columnName), Long.class);
        return BigDecimal.valueOf(bigdObj);
    }

    @Override
    public InputStream getAsciiStream(String columnName) throws SQLException {
        if (this.row.getValue(columnName) == null) {
            return null;
        }
        byte[] byteArray = this.convert(this.row.getValue(columnName), String.class).getBytes();
        return new ByteArrayInputStream(byteArray);
    }

    @Override
    public InputStream getUnicodeStream(String columnName) throws SQLException {
        if (this.row.getValue(columnName) == null) {
            return null;
        }
        byte[] byteArray = this.convert(this.row.getValue(columnName), String.class).getBytes();
        return new ByteArrayInputStream(byteArray);
    }

    @Override
    public InputStream getBinaryStream(String columnName) throws SQLException {
        if (this.row.getValue(columnName) == null) {
            return null;
        }
        byte[] byteArray = this.convert(this.row.getValue(columnName), String.class).getBytes();
        return new ByteArrayInputStream(byteArray);
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        throw new SQLException("Not supported JDBC result set function 'getWarnings'");
    }

    @Override
    public void clearWarnings() throws SQLException {
    }

    @Override
    public String getCursorName() throws SQLException {
        return "";
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return new JdbcResultSetMetaData(this.dataSet);
    }

    @Override
    public int findColumn(String columnName) throws SQLException {
        return this.row.getColumns().indexOf(columnName);
    }

    @Override
    public Reader getCharacterStream(int columnIndex) throws SQLException {
        if (this.row.getValue(columnIndex - 1) == null) {
            return null;
        }
        byte[] byteArray = this.convert(this.row.getValue(columnIndex - 1), String.class).getBytes();
        return new InputStreamReader(new ByteArrayInputStream(byteArray));
    }

    @Override
    public Reader getCharacterStream(String columnName) throws SQLException {
        if (this.row.getValue(columnName) == null) {
            return null;
        }
        byte[] byteArray = this.convert(this.row.getValue(columnName), String.class).getBytes();
        return new InputStreamReader(new ByteArrayInputStream(byteArray));
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        throw new SQLException("Not supported JDBC result set function 'isBeforeFirst'");
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        throw new SQLException("Not supported JDBC result set function 'isAfterLast'");
    }

    @Override
    public boolean isFirst() throws SQLException {
        throw new SQLException("Not supported JDBC result set function 'isFirst'");
    }

    @Override
    public boolean isLast() throws SQLException {
        throw new SQLException("Not supported JDBC result set function 'isLast'");
    }

    @Override
    public void beforeFirst() throws SQLException {
    }

    @Override
    public void afterLast() throws SQLException {
    }

    @Override
    public boolean first() throws SQLException {
        throw new SQLException("Not supported JDBC result set function 'first'");
    }

    @Override
    public boolean last() throws SQLException {
        throw new SQLException("Not supported JDBC result set function 'last'");
    }

    @Override
    public int getRow() throws SQLException {
        return this.dataSet.getCursor() + 1;
    }

    @Override
    public boolean absolute(int row) throws SQLException {
        throw new SQLException("Not supported JDBC result set function 'absolute'");
    }

    @Override
    public boolean relative(int rows) throws SQLException {
        throw new SQLException("Not supported JDBC result set function 'relative'");
    }

    @Override
    public boolean previous() throws SQLException {
        throw new SQLException("Not supported JDBC result set function 'previous'");
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
    }

    @Override
    public int getFetchDirection() throws SQLException {
        throw new SQLException("Not supported JDBC result set function 'getFetchDirection'");
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
    }

    @Override
    public int getFetchSize() throws SQLException {
        throw new SQLException("Not supported JDBC result set function 'getFetchSize'");
    }

    @Override
    public int getType() throws SQLException {
        throw new SQLException("Not supported JDBC result set function 'getType'");
    }

    @Override
    public int getConcurrency() throws SQLException {
        throw new SQLException("Not supported JDBC result set function 'getConcurrency'");
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        return this.dataSet.getRows().size() > 0;
    }

    @Override
    public boolean rowInserted() throws SQLException {
        return this.dataSet.getRows().size() > 0;
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        return this.dataSet.getRows().size() > 0;
    }

    @Override
    public void updateNull(int columnIndex) throws SQLException {
    }

    @Override
    public void updateBoolean(int columnIndex, boolean x) throws SQLException {
    }

    @Override
    public void updateByte(int columnIndex, byte x) throws SQLException {
    }

    @Override
    public void updateShort(int columnIndex, short x) throws SQLException {
    }

    @Override
    public void updateInt(int columnIndex, int x) throws SQLException {
    }

    @Override
    public void updateLong(int columnIndex, long x) throws SQLException {
    }

    @Override
    public void updateFloat(int columnIndex, float x) throws SQLException {
    }

    @Override
    public void updateDouble(int columnIndex, double x) throws SQLException {
    }

    @Override
    public void updateBigDecimal(int columnIndex, BigDecimal x) throws SQLException {
    }

    @Override
    public void updateString(int columnIndex, String x) throws SQLException {
    }

    @Override
    public void updateBytes(int columnIndex, byte[] x) throws SQLException {
    }

    @Override
    public void updateDate(int columnIndex, Date x) throws SQLException {
    }

    @Override
    public void updateTime(int columnIndex, Time x) throws SQLException {
    }

    @Override
    public void updateTimestamp(int columnIndex, Timestamp x) throws SQLException {
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, int length) throws SQLException {
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, int length) throws SQLException {
    }

    @Override
    public void updateObject(int columnIndex, Object x, int scale) throws SQLException {
    }

    @Override
    public void updateObject(int columnIndex, Object x) throws SQLException {
    }

    @Override
    public void updateNull(String columnName) throws SQLException {
    }

    @Override
    public void updateByte(String columnName, byte x) throws SQLException {
    }

    @Override
    public void updateShort(String columnName, short x) throws SQLException {
    }

    @Override
    public void updateInt(String columnName, int x) throws SQLException {
    }

    @Override
    public void updateLong(String columnName, long x) throws SQLException {
    }

    @Override
    public void updateFloat(String columnName, float x) throws SQLException {
    }

    @Override
    public void updateDouble(String columnName, double x) throws SQLException {
    }

    @Override
    public void updateBigDecimal(String columnName, BigDecimal x) throws SQLException {
    }

    @Override
    public void updateString(String columnName, String x) throws SQLException {
    }

    @Override
    public void updateBytes(String columnName, byte[] x) throws SQLException {
    }

    @Override
    public void updateDate(String columnName, Date x) throws SQLException {
    }

    @Override
    public void updateTime(String columnName, Time x) throws SQLException {
    }

    @Override
    public void updateTimestamp(String columnName, Timestamp x) throws SQLException {
    }

    @Override
    public void updateAsciiStream(String columnName, InputStream x, int length) throws SQLException {
    }

    @Override
    public void updateBinaryStream(String columnName, InputStream x, int length) throws SQLException {
    }

    @Override
    public void updateCharacterStream(String columnName, Reader reader, int length) throws SQLException {
    }

    @Override
    public void updateObject(String columnName, Object x, int scale) throws SQLException {
    }

    @Override
    public void updateObject(String columnName, Object x) throws SQLException {
    }

    @Override
    public void insertRow() throws SQLException {
    }

    @Override
    public void updateRow() throws SQLException {
    }

    @Override
    public void deleteRow() throws SQLException {
    }

    @Override
    public void refreshRow() throws SQLException {
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
    }

    @Override
    public void moveToInsertRow() throws SQLException {
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
    }

    @Override
    public Statement getStatement() throws SQLException {
        if (this.isClosed()) {
            throw new SQLException("ResultSet has already been closed.");
        }
        return this.statement;
    }

    @Override
    public Date getDate(int columnIndex, Calendar cal) throws SQLException {
        throw new SQLException("Not supported JDBC result set function 'getDate'");
    }

    @Override
    public Date getDate(String columnName, Calendar cal) throws SQLException {
        throw new SQLException("Not supported JDBC result set function 'getDate'");
    }

    @Override
    public Time getTime(int columnIndex, Calendar cal) throws SQLException {
        throw new SQLException("Not supported JDBC result set function 'getTime'");
    }

    @Override
    public Time getTime(String columnName, Calendar cal) throws SQLException {
        throw new SQLException("Not supported JDBC result set function 'getTime'");
    }

    @Override
    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        throw new SQLException("Not supported JDBC result set function 'getTimestamp'");
    }

    @Override
    public Timestamp getTimestamp(String columnName, Calendar cal) throws SQLException {
        throw new SQLException("Not supported JDBC result set function 'getTimestamp'");
    }

    @Override
    public URL getURL(int columnIndex) throws SQLException {
        throw new SQLException("Not supported JDBC result set function 'getURL'");
    }

    @Override
    public URL getURL(String columnLabel) throws SQLException {
        throw new SQLException("Not supported JDBC result set function 'getURL'");
    }

    @Override
    public void updateRef(int columnIndex, Ref x) throws SQLException {
    }

    @Override
    public void updateRef(String columnLabel, Ref x) throws SQLException {
    }

    @Override
    public void updateBlob(int columnIndex, Blob x) throws SQLException {
    }

    @Override
    public void updateBlob(String columnLabel, Blob x) throws SQLException {
    }

    @Override
    public void updateClob(int columnIndex, Clob x) throws SQLException {
    }

    @Override
    public void updateClob(String columnLabel, Clob x) throws SQLException {
    }

    @Override
    public void updateArray(int columnIndex, Array x) throws SQLException {
    }

    @Override
    public void updateArray(String columnLabel, Array x) throws SQLException {
    }

    @Override
    public RowId getRowId(int columnIndex) throws SQLException {
        throw new SQLException("Not supported JDBC result set function 'getRowId'");
    }

    @Override
    public RowId getRowId(String columnLabel) throws SQLException {
        throw new SQLException("Not supported JDBC result set function 'getRowId'");
    }

    @Override
    public void updateRowId(int columnIndex, RowId x) throws SQLException {
    }

    @Override
    public void updateRowId(String columnLabel, RowId x) throws SQLException {
    }

    @Override
    public int getHoldability() throws SQLException {
        throw new SQLException("Not supported JDBC result set function 'getHoldability'");
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.dataSet.isClosed();
    }

    @Override
    public void updateNString(int columnIndex, String nString) throws SQLException {
    }

    @Override
    public void updateNString(String columnLabel, String nString) throws SQLException {
    }

    @Override
    public void updateNClob(int columnIndex, NClob nClob) throws SQLException {
    }

    @Override
    public void updateNClob(String columnLabel, NClob nClob) throws SQLException {
    }

    @Override
    public NClob getNClob(int columnIndex) throws SQLException {
        throw new SQLException("Not supported JDBC result set function 'getNClob'");
    }

    @Override
    public NClob getNClob(String columnLabel) throws SQLException {
        throw new SQLException("Not supported JDBC result set function 'getNClob'");
    }

    @Override
    public SQLXML getSQLXML(int columnIndex) throws SQLException {
        throw new SQLException("Not supported JDBC result set function 'getSQLXML'");
    }

    @Override
    public SQLXML getSQLXML(String columnLabel) throws SQLException {
        throw new SQLException("Not supported JDBC result set function 'getSQLXML'");
    }

    @Override
    public void updateSQLXML(int columnIndex, SQLXML xmlObject) throws SQLException {
    }

    @Override
    public void updateSQLXML(String columnLabel, SQLXML xmlObject) throws SQLException {
    }

    @Override
    public String getNString(int columnIndex) throws SQLException {
        throw new SQLException("Not supported JDBC result set function 'getNString'");
    }

    @Override
    public String getNString(String columnLabel) throws SQLException {
        throw new SQLException("Not supported JDBC result set function 'getNString'");
    }

    @Override
    public Reader getNCharacterStream(int columnIndex) throws SQLException {
        throw new SQLException("Not supported JDBC result set function 'getNCharacterStream'");
    }

    @Override
    public Reader getNCharacterStream(String columnLabel) throws SQLException {
        throw new SQLException("Not supported JDBC result set function 'getNCharacterStream'");
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, long length) throws SQLException {
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, long length) throws SQLException {
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x, long length) throws SQLException {
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x, long length) throws SQLException {
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream, long length) throws SQLException {
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream, long length) throws SQLException {
    }

    @Override
    public void updateClob(int columnIndex, Reader reader, long length) throws SQLException {
    }

    @Override
    public void updateClob(String columnLabel, Reader reader, long length) throws SQLException {
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader, long length) throws SQLException {
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader, long length) throws SQLException {
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x) throws SQLException {
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader) throws SQLException {
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x) throws SQLException {
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x) throws SQLException {
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x) throws SQLException {
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x) throws SQLException {
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x) throws SQLException {
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader) throws SQLException {
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream) throws SQLException {
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream) throws SQLException {
    }

    @Override
    public void updateClob(int columnIndex, Reader reader) throws SQLException {
    }

    @Override
    public void updateClob(String columnLabel, Reader reader) throws SQLException {
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader) throws SQLException {
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader) throws SQLException {
    }

    @Override
    public <T> T getObject(int columnIndex, Class<T> type) throws SQLException {
        throw new SQLException("Not supported JDBC result set function 'getObject'");
    }

    @Override
    public <T> T getObject(String columnLabel, Class<T> type) throws SQLException {
        throw new SQLException("Not supported JDBC result set function 'getObject'");
    }

    @Override
    public boolean wasNull() throws SQLException {
        return this.row.getLastValue() == null;
    }

    @Override
    public void updateBoolean(String columnName, boolean x) throws SQLException {
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, int length) throws SQLException {
    }

    public Object getObject(int i, Map map) throws SQLException {
        throw new SQLException("Not supported JDBC result set function 'getObject'");
    }

    @Override
    public Ref getRef(int i) throws SQLException {
        throw new SQLException("Not supported JDBC result set function 'getRef'");
    }

    @Override
    public Blob getBlob(int i) throws SQLException {
        throw new SQLException("Not supported JDBC result set function 'getBlob'");
    }

    @Override
    public Clob getClob(int i) throws SQLException {
        throw new SQLException("Not supported JDBC result set function 'getClob'");
    }

    @Override
    public Array getArray(int i) throws SQLException {
        throw new SQLException("Not supported JDBC result set function 'getArray'");
    }

    public Object getObject(String colName, Map map) throws SQLException {
        throw new SQLException("Not supported JDBC result set function 'getObject'");
    }

    @Override
    public Ref getRef(String colName) throws SQLException {
        throw new SQLException("Not supported JDBC result set function 'getRef'");
    }

    @Override
    public Blob getBlob(String colName) throws SQLException {
        throw new SQLException("Not supported JDBC result set function 'getBlob'");
    }

    @Override
    public Clob getClob(String colName) throws SQLException {
        throw new SQLException("Not supported JDBC result set function 'getClob'");
    }

    @Override
    public Array getArray(String colName) throws SQLException {
        throw new SQLException("Not supported JDBC result set function 'getArray'");
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new SQLException("Not supported JDBC result set function 'unwrap'");
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        throw new SQLException("Not supported JDBC result set function 'isWrapperFor'");
    }
}

