/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.db.driver;

import com.consol.citrus.db.driver.JdbcConnection;
import com.consol.citrus.db.driver.JdbcResultSet;
import com.consol.citrus.db.driver.dataset.DataSet;
import com.consol.citrus.db.driver.json.JsonDataSetProducer;
import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.Objects;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.client.utils.HttpClientUtils;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.util.EntityUtils;

public class JdbcStatement
implements Statement {
    private final HttpClient httpClient;
    private final String serverUrl;
    private final JdbcConnection connection;
    protected DataSet dataSet = new DataSet();

    JdbcStatement(HttpClient httpClient, String serverUrl, JdbcConnection connection) {
        this.httpClient = httpClient;
        this.serverUrl = serverUrl;
        this.connection = connection;
    }

    @Override
    public ResultSet executeQuery(String sqlQuery) throws SQLException {
        JdbcResultSet jdbcResultSet;
        HttpResponse response = null;
        try {
            response = this.httpClient.execute(RequestBuilder.post((String)(this.serverUrl + "/query")).setEntity((HttpEntity)new StringEntity(sqlQuery, ContentType.create((String)"text/plain", (String)"UTF-8"))).build());
            if (200 != response.getStatusLine().getStatusCode() || !response.getEntity().getContentType().getValue().equals("application/json")) {
                throw new SQLException("Failed to execute query: " + sqlQuery);
            }
            this.dataSet = new JsonDataSetProducer(response.getEntity().getContent()).produce();
            jdbcResultSet = new JdbcResultSet(this.dataSet, this);
        }
        catch (IOException e) {
            try {
                throw new SQLException(e);
            }
            catch (Throwable throwable) {
                HttpClientUtils.closeQuietly(response);
                throw throwable;
            }
        }
        HttpClientUtils.closeQuietly((HttpResponse)response);
        return jdbcResultSet;
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        int n;
        HttpResponse response = null;
        try {
            response = this.httpClient.execute(RequestBuilder.post((String)(this.serverUrl + "/update")).setEntity((HttpEntity)new StringEntity(sql, ContentType.create((String)"text/plain", (String)"UTF-8"))).build());
            if (200 != response.getStatusLine().getStatusCode()) {
                throw new SQLException("Failed to execute update: " + EntityUtils.toString((HttpEntity)response.getEntity()));
            }
            String responseBody = EntityUtils.toString((HttpEntity)response.getEntity());
            n = Integer.valueOf(responseBody);
        }
        catch (IOException e) {
            try {
                throw new SQLException(e);
            }
            catch (Throwable throwable) {
                HttpClientUtils.closeQuietly(response);
                throw throwable;
            }
        }
        HttpClientUtils.closeQuietly((HttpResponse)response);
        return n;
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        boolean bl;
        HttpResponse response = null;
        try {
            response = this.httpClient.execute(RequestBuilder.post((String)(this.serverUrl + "/execute")).setEntity((HttpEntity)new StringEntity(sql, ContentType.create((String)"text/plain", (String)"UTF-8"))).build());
            if (200 != response.getStatusLine().getStatusCode()) {
                throw new SQLException(String.format("Failed to execute statement '%s' due to server error: %s %s", sql, response.getStatusLine().getStatusCode(), response.getStatusLine().getReasonPhrase()));
            }
            if (response.getEntity().getContentType().getValue().equals("application/json")) {
                this.dataSet = new JsonDataSetProducer(response.getEntity().getContent()).produce();
            }
            bl = true;
        }
        catch (IOException e) {
            try {
                throw new SQLException(e);
            }
            catch (Throwable throwable) {
                HttpClientUtils.closeQuietly(response);
                throw throwable;
            }
        }
        HttpClientUtils.closeQuietly((HttpResponse)response);
        return bl;
    }

    @Override
    public void close() throws SQLException {
        HttpResponse response = null;
        try {
            response = this.httpClient.execute(RequestBuilder.delete((String)(this.serverUrl + "/statement")).build());
            if (response.getStatusLine().getStatusCode() < 200 || response.getStatusLine().getStatusCode() > 299) {
                throw new SQLException("Failed to close statement");
            }
        }
        catch (IOException e) {
            try {
                throw new SQLException(e);
            }
            catch (Throwable throwable) {
                HttpClientUtils.closeQuietly(response);
                throw throwable;
            }
        }
        HttpClientUtils.closeQuietly((HttpResponse)response);
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        throw new SQLException("Not supported JDBC statement function 'getMaxFieldSize'");
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
    }

    @Override
    public int getMaxRows() throws SQLException {
        throw new SQLException("Not supported JDBC statement function 'getMaxRows'");
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        throw new SQLException("Not supported JDBC statement function 'getQueryTimeout'");
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
    }

    @Override
    public void cancel() throws SQLException {
        throw new SQLException("Not supported JDBC statement function 'cancel'");
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return null;
    }

    @Override
    public void clearWarnings() throws SQLException {
        throw new SQLException("Not supported JDBC statement function 'clearWarnings'");
    }

    @Override
    public void setCursorName(String name) throws SQLException {
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        return new JdbcResultSet(this.dataSet, this);
    }

    @Override
    public int getUpdateCount() throws SQLException {
        return -1;
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        return false;
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
    }

    @Override
    public int getFetchDirection() throws SQLException {
        throw new SQLException("Not supported JDBC statement function 'getFetchDirection'");
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
    }

    @Override
    public int getFetchSize() throws SQLException {
        throw new SQLException("Not supported JDBC statement function 'getFetchSize'");
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        throw new SQLException("Not supported JDBC statement function 'getResultSetConcurrency'");
    }

    @Override
    public int getResultSetType() throws SQLException {
        throw new SQLException("Not supported JDBC statement function 'getResultSetType'");
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        throw new SQLException("Not supported JDBC statement function 'addBatch'");
    }

    @Override
    public void clearBatch() throws SQLException {
        throw new SQLException("Not supported JDBC statement function 'clearBatch'");
    }

    @Override
    public int[] executeBatch() throws SQLException {
        throw new SQLException("Not supported JDBC statement function 'executeBatch'");
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.connection;
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        throw new SQLException("Not supported JDBC statement function 'getMoreResults'");
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        throw new SQLException("Not supported JDBC statement function 'getGeneratedKeys'");
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        throw new SQLException("Not supported JDBC statement function 'executeUpdate'");
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        throw new SQLException("Not supported JDBC statement function 'executeUpdate'");
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        throw new SQLException("Not supported JDBC statement function 'executeUpdate'");
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        throw new SQLException("Not supported JDBC statement function 'execute'");
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        throw new SQLException("Not supported JDBC statement function 'execute'");
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        throw new SQLException("Not supported JDBC statement function 'execute'");
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        throw new SQLException("Not supported JDBC statement function 'getResultSetHoldability'");
    }

    @Override
    public boolean isClosed() throws SQLException {
        throw new SQLException("Not supported JDBC statement function 'isClosed'");
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
    }

    @Override
    public boolean isPoolable() throws SQLException {
        throw new SQLException("Not supported JDBC statement function 'isPoolable'");
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        throw new SQLException("Not supported JDBC statement function 'closeOnCompletion'");
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        throw new SQLException("Not supported JDBC statement function 'isCloseOnCompletion'");
    }

    @Override
    public long getLargeUpdateCount() throws SQLException {
        throw new SQLException("Not supported JDBC statement function 'getLargeUpdateCount'");
    }

    @Override
    public void setLargeMaxRows(long max) throws SQLException {
    }

    @Override
    public long getLargeMaxRows() throws SQLException {
        throw new SQLException("Not supported JDBC statement function 'getLargeMaxRows'");
    }

    @Override
    public long[] executeLargeBatch() throws SQLException {
        throw new SQLException("Not supported JDBC statement function 'executeLargeBatch'");
    }

    @Override
    public long executeLargeUpdate(String sql) throws SQLException {
        throw new SQLException("Not supported JDBC statement function 'executeLargeUpdate'");
    }

    @Override
    public long executeLargeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        throw new SQLException("Not supported JDBC statement function 'executeLargeUpdate'");
    }

    @Override
    public long executeLargeUpdate(String sql, int[] columnIndexes) throws SQLException {
        throw new SQLException("Not supported JDBC statement function 'executeLargeUpdate'");
    }

    @Override
    public long executeLargeUpdate(String sql, String[] columnNames) throws SQLException {
        throw new SQLException("Not supported JDBC statement function 'executeLargeUpdate'");
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new SQLException("Not supported JDBC statement function 'unwrap'");
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        throw new SQLException("Not supported JDBC statement function 'isWrapperFor'");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JdbcStatement that = (JdbcStatement)o;
        return Objects.equals(this.httpClient, that.httpClient) && Objects.equals(this.serverUrl, that.serverUrl) && Objects.equals(this.dataSet, that.dataSet);
    }
}

