/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.db.driver.dataset;

import com.consol.citrus.db.driver.data.Row;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;

public class DataSet {
    private final List<Row> rows = new ArrayList<Row>();
    private boolean closed = false;
    private AtomicInteger cursor = new AtomicInteger(0);

    public Row getNextRow() throws SQLException {
        this.checkNotClosed();
        return this.rows.get(this.cursor.getAndIncrement());
    }

    public List<String> getColumns() {
        return this.rows.stream().flatMap(row -> row.getColumns().stream()).distinct().collect(Collectors.toList());
    }

    public List<Row> getRows() throws SQLException {
        this.checkNotClosed();
        return this.rows;
    }

    public int getCursor() {
        return this.cursor.get();
    }

    public void close() {
        this.closed = true;
    }

    private void checkNotClosed() throws SQLException {
        if (this.closed) {
            throw new SQLException("Result set already closed");
        }
    }

    public boolean isClosed() {
        return this.closed;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataSet dataSet = (DataSet)o;
        return this.closed == dataSet.closed && Objects.equals(this.rows, dataSet.rows) && Objects.equals(this.cursor.get(), dataSet.cursor.get());
    }
}

