/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.db.driver.dataset;

import com.consol.citrus.db.driver.data.Row;
import com.consol.citrus.db.driver.data.Table;
import com.consol.citrus.db.driver.dataset.DataSet;
import com.consol.citrus.db.driver.dataset.DataSetBuilder;
import com.consol.citrus.db.driver.dataset.DataSetProducer;
import java.sql.SQLException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;

public class TableDataSetProducer
implements DataSetProducer {
    private final Table table;
    private int limit;
    private Function<Row, Row> mapper = row -> row;
    private Map<String, String> filter = new LinkedHashMap<String, String>();

    public TableDataSetProducer(Table table) {
        this(table, table.getRows().size(), new String[0]);
    }

    public TableDataSetProducer(Table table, String ... columnNames) {
        this(table, table.getRows().size(), columnNames);
    }

    public TableDataSetProducer(Table table, int limit, String ... columnNames) {
        this.table = table;
        this.limit = limit;
        if (columnNames.length > 0) {
            this.mapper = row -> {
                Row mapped = new Row();
                for (String name : columnNames) {
                    mapped.getValues().put(name, row.getValues().entrySet().stream().filter(entry -> ((String)entry.getKey()).equals(name)).map(Map.Entry::getValue).findFirst().orElse(""));
                }
                return mapped;
            };
        }
    }

    public TableDataSetProducer filter(String key, String value) {
        this.filter.put(key, value);
        return this;
    }

    @Override
    public DataSet produce() throws SQLException {
        DataSetBuilder builder = new DataSetBuilder();
        this.table.getRows().stream().filter(row -> this.filter.entrySet().stream().allMatch(entry -> row.getValues().containsKey(entry.getKey()) && row.getValue((String)entry.getKey()).equals(entry.getValue()))).limit(this.limit).map(this.mapper).forEach(xva$0 -> builder.add((Row)xva$0));
        return builder.build();
    }

    public int getLimit() {
        return this.limit;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }
}

