/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.db.driver.json;

import com.consol.citrus.db.driver.JdbcDriverException;
import com.consol.citrus.db.driver.data.Row;
import com.consol.citrus.db.driver.dataset.DataSet;
import com.consol.citrus.db.driver.dataset.DataSetBuilder;
import com.consol.citrus.db.driver.dataset.DataSetProducer;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;

public class JsonDataSetProducer
implements DataSetProducer {
    private final InputStream input;
    private DataSetBuilder builder;

    public JsonDataSetProducer(File file) {
        this(file.toPath());
    }

    public JsonDataSetProducer(Path path) {
        try {
            this.input = new FileInputStream(path.toFile());
        }
        catch (FileNotFoundException e) {
            throw new JdbcDriverException("Failed to access json input file content", e);
        }
    }

    public JsonDataSetProducer(String jsonInput) {
        this.input = new ByteArrayInputStream(jsonInput.getBytes());
    }

    public JsonDataSetProducer(InputStream inputStream) {
        this.input = inputStream;
    }

    @Override
    public DataSet produce() throws SQLException {
        if (this.builder != null) {
            return this.builder.build();
        }
        this.builder = new DataSetBuilder();
        try {
            List rawDataSet = (List)new ObjectMapper().readValue(this.input, List.class);
            rawDataSet.forEach(rowData -> {
                Row row = new Row();
                row.getValues().putAll((Map<String, Object>)rowData);
                this.builder.add(row);
            });
        }
        catch (IOException e) {
            throw new JdbcDriverException("Unable to read table data set from Json input", e);
        }
        return this.builder.build();
    }
}

