/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.db.driver.json;

import com.consol.citrus.db.driver.JdbcDriverException;
import com.consol.citrus.db.driver.dataset.DataSet;
import com.consol.citrus.db.driver.dataset.DataSetWriter;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.sql.SQLException;
import java.util.ArrayList;

public class JsonDataSetWriter
implements DataSetWriter {
    @Override
    public String write(DataSet dataSet) {
        try {
            ArrayList rawDataSet = new ArrayList();
            dataSet.getRows().forEach(row -> rawDataSet.add(row.getValues()));
            ObjectMapper mapper = new ObjectMapper();
            mapper.enable(SerializationFeature.INDENT_OUTPUT);
            return mapper.writeValueAsString(rawDataSet);
        }
        catch (JsonProcessingException | SQLException e) {
            throw new JdbcDriverException("Failed to write json dataset", e);
        }
    }
}

