/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.db.driver.json;

import com.consol.citrus.db.driver.JdbcDriverException;
import com.consol.citrus.db.driver.data.Row;
import com.consol.citrus.db.driver.data.Table;
import com.consol.citrus.db.driver.data.TableProducer;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class JsonTableProducer
implements TableProducer {
    private final InputStream input;

    public JsonTableProducer(File file) {
        this(file.toPath());
    }

    public JsonTableProducer(Path path) {
        try {
            this.input = new FileInputStream(path.toFile());
        }
        catch (IOException e) {
            throw new JdbcDriverException(e);
        }
    }

    public JsonTableProducer(String jsonInput) {
        this.input = new ByteArrayInputStream(jsonInput.getBytes());
    }

    public JsonTableProducer(InputStream inputStream) {
        this.input = inputStream;
    }

    @Override
    public List<Table> produce() {
        ArrayList<Table> tables = new ArrayList<Table>();
        try {
            Map rawDataSet = (Map)new ObjectMapper().readValue(this.input, Map.class);
            for (Map.Entry tableData : rawDataSet.entrySet()) {
                Table table = new Table((String)tableData.getKey());
                ((List)tableData.getValue()).forEach(rowData -> {
                    Row row = new Row();
                    row.getValues().putAll((Map<String, Object>)rowData);
                    table.getRows().add(row);
                });
                tables.add(table);
            }
        }
        catch (IOException e) {
            throw new JdbcDriverException("Unable to read table data set from Json input", e);
        }
        return tables;
    }
}

