/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.db.driver.xml;

import com.consol.citrus.db.driver.JdbcDriverException;
import com.consol.citrus.db.driver.data.Row;
import com.consol.citrus.db.driver.dataset.DataSet;
import com.consol.citrus.db.driver.dataset.DataSetBuilder;
import com.consol.citrus.db.driver.dataset.DataSetProducer;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.nio.file.Path;
import java.sql.SQLException;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSParser;

public class XmlDataSetProducer
implements DataSetProducer {
    private final InputStream input;
    private DataSetBuilder builder;

    public XmlDataSetProducer(File file) {
        this(file.toPath());
    }

    public XmlDataSetProducer(Path path) {
        try {
            this.input = new FileInputStream(path.toFile());
        }
        catch (FileNotFoundException e) {
            throw new JdbcDriverException("Failed to access xml input file content", e);
        }
    }

    public XmlDataSetProducer(String xmlInput) {
        this.input = new ByteArrayInputStream(xmlInput.getBytes());
    }

    public XmlDataSetProducer(InputStream inputStream) {
        this.input = inputStream;
    }

    @Override
    public DataSet produce() throws SQLException {
        if (this.builder != null) {
            return this.builder.build();
        }
        this.builder = new DataSetBuilder();
        try {
            DOMImplementationLS domImpl = (DOMImplementationLS)((Object)DOMImplementationRegistry.newInstance().getDOMImplementation("LS"));
            LSParser parser = domImpl.createLSParser((short)1, null);
            LSInput lsInput = domImpl.createLSInput();
            lsInput.setByteStream(this.input);
            Document document = parser.parse(lsInput);
            NodeList rows = document.getDocumentElement().getChildNodes();
            for (int i = 0; i < rows.getLength(); ++i) {
                int k;
                Node rowNode = rows.item(i);
                if (!(rowNode instanceof Element)) continue;
                Element rowElement = (Element)rowNode;
                Row row = new Row();
                NodeList columns = rowElement.getChildNodes();
                for (k = 0; k < columns.getLength(); ++k) {
                    Node columnNode = columns.item(k);
                    if (!(columnNode instanceof Element)) continue;
                    Element columnElement = (Element)columnNode;
                    StringBuilder nodeValue = new StringBuilder();
                    NodeList textNodes = columnElement.getChildNodes();
                    for (int m = 0; m < textNodes.getLength(); ++m) {
                        Node item = textNodes.item(m);
                        if ((!(item instanceof CharacterData) || item instanceof Comment) && !(item instanceof EntityReference)) continue;
                        nodeValue.append(item.getNodeValue());
                    }
                    row.getValues().put(columnElement.getTagName(), nodeValue.toString());
                }
                for (k = 0; k < rowElement.getAttributes().getLength(); ++k) {
                    Node column = rowElement.getAttributes().item(k);
                    row.getValues().put(column.getLocalName(), column.getNodeValue());
                }
                this.builder.add(row);
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new JdbcDriverException("Unable to read table data set from Json input", e);
        }
        return this.builder.build();
    }
}

