/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.db.driver.xml;

import com.consol.citrus.db.driver.JdbcDriverException;
import com.consol.citrus.db.driver.dataset.DataSet;
import com.consol.citrus.db.driver.dataset.DataSetWriter;
import java.sql.SQLException;

public class XmlDataSetWriter
implements DataSetWriter {
    private final String DATASET = "dataset";
    private final String ROW = "row";
    private short mode = 1;
    private String spaces = "  ";

    @Override
    public String write(DataSet dataSet) {
        try {
            StringBuilder xmlOutput = new StringBuilder();
            xmlOutput.append("<").append("dataset").append(">\n");
            dataSet.getRows().forEach(row -> {
                if (this.mode == 1) {
                    xmlOutput.append(this.spaces).append("<").append("row").append(">\n");
                    row.getValues().forEach((key, value) -> {
                        xmlOutput.append(this.spaces).append(this.spaces).append("<").append((String)key).append(">");
                        xmlOutput.append(value);
                        xmlOutput.append("</").append((String)key).append(">\n");
                    });
                    xmlOutput.append(this.spaces).append("</").append("row").append(">\n");
                } else if (this.mode == 2) {
                    xmlOutput.append(this.spaces).append("<").append("row").append("\n");
                    row.getValues().forEach((key, value) -> xmlOutput.append(this.spaces).append(this.spaces).append((String)key).append("=\"").append(value).append("\"").append("\n"));
                    xmlOutput.append(this.spaces).append(this.spaces).append("/>\n");
                }
            });
            xmlOutput.append("</").append("dataset").append(">");
            return xmlOutput.toString();
        }
        catch (SQLException e) {
            throw new JdbcDriverException("Failed to write xml dataset", e);
        }
    }

    public short getMode() {
        return this.mode;
    }

    public void setMode(short mode) {
        this.mode = mode;
    }

    public int getIndent() {
        return this.spaces.length();
    }

    public void setIndent(int indent) {
        StringBuilder spacesBuilder = new StringBuilder();
        for (int i = 0; i < indent; ++i) {
            spacesBuilder.append(" ");
        }
        this.spaces = spacesBuilder.toString();
    }
}

