/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.db.driver.xml;

import com.consol.citrus.db.driver.JdbcDriverException;
import com.consol.citrus.db.driver.data.Row;
import com.consol.citrus.db.driver.data.Table;
import com.consol.citrus.db.driver.data.TableProducer;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSParser;

public class XmlTableProducer
implements TableProducer {
    private final InputStream input;

    public XmlTableProducer(File file) {
        this(file.toPath());
    }

    public XmlTableProducer(Path path) {
        try {
            this.input = new FileInputStream(path.toFile());
        }
        catch (IOException e) {
            throw new JdbcDriverException(e);
        }
    }

    public XmlTableProducer(String jsonInput) {
        this.input = new ByteArrayInputStream(jsonInput.getBytes());
    }

    public XmlTableProducer(InputStream inputStream) {
        this.input = inputStream;
    }

    @Override
    public List<Table> produce() {
        ArrayList<Table> tables = new ArrayList<Table>();
        try {
            DOMImplementationLS domImpl = (DOMImplementationLS)((Object)DOMImplementationRegistry.newInstance().getDOMImplementation("LS"));
            LSParser parser = domImpl.createLSParser((short)1, null);
            LSInput lsInput = domImpl.createLSInput();
            lsInput.setByteStream(this.input);
            Document document = parser.parse(lsInput);
            NodeList tableNodes = document.getDocumentElement().getChildNodes();
            for (int i = 0; i < tableNodes.getLength(); ++i) {
                Node tableNode = tableNodes.item(i);
                if (!(tableNode instanceof Element)) continue;
                Table table = new Table(((Element)tableNode).getTagName());
                NodeList rows = tableNode.getChildNodes();
                for (int j = 0; j < rows.getLength(); ++j) {
                    int k;
                    Node rowNode = rows.item(j);
                    if (!(rowNode instanceof Element)) continue;
                    Element rowElement = (Element)rowNode;
                    Row row = new Row();
                    NodeList columns = rowElement.getChildNodes();
                    for (k = 0; k < columns.getLength(); ++k) {
                        Node columnNode = columns.item(k);
                        if (!(columnNode instanceof Element)) continue;
                        Element columnElement = (Element)columnNode;
                        StringBuilder nodeValue = new StringBuilder();
                        NodeList textNodes = columnElement.getChildNodes();
                        for (int m = 0; m < textNodes.getLength(); ++m) {
                            Node item = textNodes.item(m);
                            if ((!(item instanceof CharacterData) || item instanceof Comment) && !(item instanceof EntityReference)) continue;
                            nodeValue.append(item.getNodeValue());
                        }
                        row.getValues().put(columnElement.getTagName(), nodeValue.toString());
                    }
                    for (k = 0; k < rowElement.getAttributes().getLength(); ++k) {
                        Node column = rowElement.getAttributes().item(k);
                        row.getValues().put(column.getLocalName(), column.getNodeValue());
                    }
                    table.getRows().add(row);
                }
                tables.add(table);
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new JdbcDriverException("Unable to read table data set from Json input", e);
        }
        return tables;
    }
}

