/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.db.server;

import com.consol.citrus.db.server.JdbcServerConfiguration;
import com.consol.citrus.db.server.JdbcServerException;
import com.consol.citrus.db.server.JdbcServerOptions;
import com.consol.citrus.db.server.builder.RuleBasedControllerBuilder;
import com.consol.citrus.db.server.controller.JdbcController;
import com.consol.citrus.db.server.controller.RuleBasedController;
import com.consol.citrus.db.server.controller.SimpleJdbcController;
import com.consol.citrus.db.server.exceptionhandler.JdbcServerExceptionHandler;
import com.consol.citrus.db.server.handler.connection.CloseConnectionHandler;
import com.consol.citrus.db.server.handler.connection.CommitTransactionStatementsHandler;
import com.consol.citrus.db.server.handler.connection.GetTransactionStateHandler;
import com.consol.citrus.db.server.handler.connection.OpenConnectionHandler;
import com.consol.citrus.db.server.handler.connection.RollbackTransactionStatementsHandler;
import com.consol.citrus.db.server.handler.connection.SetTransactionStateHandler;
import com.consol.citrus.db.server.handler.statement.CloseStatementHandler;
import com.consol.citrus.db.server.handler.statement.CreateCallableStatementHandler;
import com.consol.citrus.db.server.handler.statement.CreatePreparedStatementHandler;
import com.consol.citrus.db.server.handler.statement.CreateStatementHandler;
import com.consol.citrus.db.server.handler.statement.ExecuteQueryHandler;
import com.consol.citrus.db.server.handler.statement.ExecuteStatementHandler;
import com.consol.citrus.db.server.handler.statement.ExecuteUpdateHandler;
import com.consol.citrus.db.server.transformer.JsonResponseTransformer;
import com.consol.citrus.db.server.util.DeamonThread;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import spark.ExceptionHandler;
import spark.ResponseTransformer;
import spark.Route;
import spark.Service;

public class JdbcServer {
    private static Logger log = LoggerFactory.getLogger(JdbcServer.class);
    private final JdbcServerConfiguration configuration;
    private JdbcController controller;
    private Service service;
    private JsonResponseTransformer responseTransformer = new JsonResponseTransformer();

    public JdbcServer() {
        this(new JdbcServerConfiguration());
    }

    public JdbcServer(JdbcServerConfiguration configuration) {
        this(new SimpleJdbcController(), configuration);
    }

    public JdbcServer(JdbcController controller, JdbcServerConfiguration configuration) {
        this.controller = controller;
        this.configuration = configuration;
    }

    public JdbcServer(String[] args) throws JdbcServerException {
        this();
        new JdbcServerOptions().apply(this.configuration, args);
    }

    public RuleBasedControllerBuilder when() {
        if (!RuleBasedController.class.isAssignableFrom(this.controller.getClass())) {
            this.controller = new RuleBasedController();
        }
        return new RuleBasedControllerBuilder((RuleBasedController)this.controller);
    }

    public static void main(String[] args) throws JdbcServerException {
        JdbcServer server = new JdbcServer(args);
        if (server.configuration.getTimeToLive() > 0L) {
            CompletableFuture.runAsync(() -> {
                try {
                    new CompletableFuture().get(server.configuration.getTimeToLive(), TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException | ExecutionException | TimeoutException e) {
                    server.stop();
                }
            });
        }
        server.start();
    }

    public void start() {
        if (this.configuration.isDeamon()) {
            Executors.newSingleThreadExecutor(DeamonThread::new).submit(this::initService);
        } else {
            this.initService();
        }
    }

    private void initService() {
        this.service = Service.ignite();
        this.service.port(this.configuration.getPort());
        this.service.before((request, response) -> log.info(request.requestMethod() + " " + request.url()));
        this.registerEndpoints();
        this.service.exception(JdbcServerException.class, (ExceptionHandler)new JdbcServerExceptionHandler());
    }

    private void registerEndpoints() {
        this.registerConnectionEndpoint();
        this.registerStatementEndpoint();
        this.registerPreparedStatementEndpoint();
        this.registerCallableStatementEndpoint();
    }

    private void registerConnectionEndpoint() {
        this.service.path("/connection", () -> {
            this.service.get("", (Route)new OpenConnectionHandler(this.controller));
            this.service.delete("", (Route)new CloseConnectionHandler(this.controller));
        });
        this.service.path("/connection/transaction", () -> {
            this.service.get("", (Route)new GetTransactionStateHandler(this.controller));
            this.service.post("", (Route)new SetTransactionStateHandler(this.controller));
            this.service.put("", (Route)new CommitTransactionStatementsHandler(this.controller));
            this.service.delete("", (Route)new RollbackTransactionStatementsHandler(this.controller));
        });
    }

    private void registerStatementEndpoint() {
        this.service.path("/statement", () -> {
            this.service.get("", (Route)new CreateStatementHandler(this.controller));
            this.service.delete("", (Route)new CloseStatementHandler(this.controller));
        });
        this.service.post("/query", (Route)new ExecuteQueryHandler(this.controller), (ResponseTransformer)this.responseTransformer);
        this.service.post("/execute", (Route)new ExecuteStatementHandler(this.controller), (ResponseTransformer)this.responseTransformer);
        this.service.post("/update", (Route)new ExecuteUpdateHandler(this.controller));
    }

    private void registerPreparedStatementEndpoint() {
        this.service.post("/preparedStatement", (Route)new CreatePreparedStatementHandler(this.controller));
    }

    private void registerCallableStatementEndpoint() {
        this.service.post("/callableStatement", (Route)new CreateCallableStatementHandler(this.controller));
    }

    public void stop() {
        if (this.service != null) {
            this.service.stop();
        }
    }

    public void startAndAwaitInitialization() {
        this.start();
        this.service.awaitInitialization();
    }
}

