/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.db.server;

import com.consol.citrus.db.server.JdbcServerConfiguration;
import com.consol.citrus.db.server.JdbcServerException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcServerOptions {
    private static Logger log = LoggerFactory.getLogger(JdbcServerOptions.class);
    protected final List<CliOption> options = new ArrayList<CliOption>();

    public JdbcServerOptions() {
        this.options.add(new CliOption("h", "help", "Displays cli option usage"){

            @Override
            protected void doProcess(JdbcServerConfiguration configuration, String arg, String value, LinkedList<String> remainingArgs) {
                StringBuilder builder = new StringBuilder();
                builder.append(System.lineSeparator()).append("Jdbc server option usage:").append(System.lineSeparator());
                for (CliOption option : JdbcServerOptions.this.options) {
                    builder.append(option.getInformation()).append(System.lineSeparator());
                }
                log.info(builder.toString());
                configuration.setTimeToLive(1000L);
            }
        });
        this.options.add(new CliOption("t", "time", "Maximum time in milliseconds the server should be up and running - server will terminate automatically when time exceeds"){

            @Override
            protected void doProcess(JdbcServerConfiguration configuration, String arg, String value, LinkedList<String> remainingArgs) throws JdbcServerException {
                if (value == null || value.length() <= 0) {
                    throw new JdbcServerException("Missing parameter value for -t/-time option");
                }
                configuration.setTimeToLive(Long.valueOf(value));
            }
        });
        this.options.add(new CliOption("d", "deamon", "Flag to indicate that this server should be started as deamon thread"){

            @Override
            protected void doProcess(JdbcServerConfiguration configuration, String arg, String value, LinkedList<String> remainingArgs) throws JdbcServerException {
                if (value == null || value.length() <= 0) {
                    throw new JdbcServerException("Missing parameter value for -d/-deamon option");
                }
                configuration.setDeamon(Boolean.valueOf(value));
            }
        });
        this.options.add(new CliOption("p", "port", "Jdbc server port"){

            @Override
            protected void doProcess(JdbcServerConfiguration configuration, String arg, String value, LinkedList<String> remainingArgs) throws JdbcServerException {
                if (value == null || value.length() <= 0) {
                    throw new JdbcServerException("Missing parameter value for -p/-port option");
                }
                configuration.setPort(Integer.valueOf(value));
            }
        });
    }

    public void apply(JdbcServerConfiguration configuration, String[] arguments) throws JdbcServerException {
        LinkedList<String> args = new LinkedList<String>(Arrays.asList(arguments));
        while (!args.isEmpty()) {
            String arg = args.removeFirst();
            for (CliOption option : this.options) {
                if (option.processOption(configuration, arg, args)) break;
            }
        }
    }

    public abstract class CliOption {
        private String shortName;
        private String fullName;
        private String description;

        protected CliOption(String shortName, String fullName, String description) {
            this.shortName = "-" + shortName;
            this.fullName = "-" + fullName;
            this.description = description;
        }

        public boolean processOption(JdbcServerConfiguration configuration, String arg, LinkedList<String> remainingArgs) throws JdbcServerException {
            if (arg.equalsIgnoreCase(this.shortName) || this.fullName.startsWith(arg)) {
                if (remainingArgs.isEmpty()) {
                    this.doProcess(configuration, arg, null, remainingArgs);
                } else {
                    this.doProcess(configuration, arg, remainingArgs.removeFirst(), remainingArgs);
                }
                return true;
            }
            return false;
        }

        public String getShortName() {
            return this.shortName;
        }

        public String getDescription() {
            return this.description;
        }

        public String getFullName() {
            return this.fullName;
        }

        public String getInformation() {
            return "  " + this.getShortName() + " or " + this.getFullName() + " = " + this.getDescription();
        }

        protected abstract void doProcess(JdbcServerConfiguration var1, String var2, String var3, LinkedList<String> var4) throws JdbcServerException;
    }
}

