/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.db.server.builder;

import com.consol.citrus.db.server.builder.AbstractRuleBuilder;
import com.consol.citrus.db.server.controller.RuleBasedController;
import com.consol.citrus.db.server.rules.Mapping;
import com.consol.citrus.db.server.rules.Precondition;
import com.consol.citrus.db.server.rules.Rule;

public abstract class AbstractDecisionMakingRuleBuilder<T extends Rule<P, Boolean, T>, P>
extends AbstractRuleBuilder<T, P, Boolean> {
    private Precondition<P> precondition;

    public AbstractDecisionMakingRuleBuilder(RuleBasedController controller) {
        super(controller);
    }

    public AbstractDecisionMakingRuleBuilder(RuleBasedController controller, Precondition<P> precondition) {
        super(controller);
        this.setPrecondition(precondition);
    }

    public T thenAccept() {
        if (this.precondition != null) {
            return this.thenAcceptWithPrecondition(this.precondition);
        }
        return this.thenAcceptWithoutPrecondition();
    }

    public T thenRefuse() {
        if (this.precondition != null) {
            return this.thenRefuseWithPrecondition(this.precondition);
        }
        return this.thenRefuseWithoutPrecondition();
    }

    private T thenAcceptWithoutPrecondition() {
        Object rule = this.createRule(Precondition.matchAll(), this.accept());
        this.addRule(rule);
        return rule;
    }

    private T thenAcceptWithPrecondition(Precondition<P> precondition) {
        Object rule = this.createRule(precondition, this.accept());
        this.addRule(rule);
        return rule;
    }

    private T thenRefuseWithoutPrecondition() {
        Object rule = this.createRule(Precondition.matchAll(), this.refuse());
        this.addRule(rule);
        return rule;
    }

    private T thenRefuseWithPrecondition(Precondition<P> precondition) {
        Object rule = this.createRule(precondition, this.refuse());
        this.addRule(rule);
        return rule;
    }

    private Mapping<P, Boolean> accept() {
        return any -> true;
    }

    private Mapping<P, Boolean> refuse() {
        return any -> false;
    }

    protected void setPrecondition(Precondition<P> precondition) {
        this.precondition = precondition;
    }

    protected Precondition<P> getPrecondition() {
        return this.precondition;
    }
}

