/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.db.server.builder;

import com.consol.citrus.db.server.JdbcServerException;
import com.consol.citrus.db.server.controller.RuleBasedController;
import com.consol.citrus.db.server.rules.Mapping;
import com.consol.citrus.db.server.rules.Precondition;
import com.consol.citrus.db.server.rules.Rule;

public abstract class AbstractRuleBuilder<T extends Rule<P, R, T>, P, R> {
    private RuleBasedController controller;

    AbstractRuleBuilder(RuleBasedController controller) {
        this.controller = controller;
    }

    public T thenThrow(JdbcServerException exception) {
        T rule = this.createRule(Precondition.matchAll(), any -> {
            throw exception;
        });
        this.addRule(rule);
        return rule;
    }

    void addRule(T rule) {
        this.controller.add((Rule)rule);
    }

    protected abstract T createRule(Precondition<P> var1, Mapping<P, R> var2);

    RuleBasedController getController() {
        return this.controller;
    }
}

