/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.db.server.builder;

import com.consol.citrus.db.server.builder.CloseConnectionRuleBuilder;
import com.consol.citrus.db.server.builder.CommitTransactionRuleBuilder;
import com.consol.citrus.db.server.builder.OpenConnectionRuleBuilder;
import com.consol.citrus.db.server.builder.RollbackTransactionRuleBuilder;
import com.consol.citrus.db.server.builder.StartTransactionRuleBuilder;
import com.consol.citrus.db.server.controller.RuleBasedController;
import com.consol.citrus.db.server.rules.Precondition;
import java.util.Map;
import java.util.Optional;

public class ConnectionRuleBuilder {
    private RuleBasedController controller;

    ConnectionRuleBuilder(RuleBasedController controller) {
        this.controller = controller;
    }

    public CloseConnectionRuleBuilder close() {
        return new CloseConnectionRuleBuilder(this.controller);
    }

    public OpenConnectionRuleBuilder open() {
        return this.open(Precondition.matchAll());
    }

    public OpenConnectionRuleBuilder open(String username) {
        return this.open((Map<String, String> properties) -> this.propertyMatchesValue((String)properties.get("username"), username));
    }

    public OpenConnectionRuleBuilder open(String username, String password) {
        return this.open((Map<String, String> properties) -> this.propertyMatchesValue((String)properties.get("username"), username) && this.propertyMatchesValue((String)properties.get("password"), password));
    }

    public OpenConnectionRuleBuilder open(Precondition<Map<String, String>> precondition) {
        return new OpenConnectionRuleBuilder(precondition, this.controller);
    }

    public StartTransactionRuleBuilder startTransaction() {
        return new StartTransactionRuleBuilder(this.controller);
    }

    public CommitTransactionRuleBuilder commitTransaction() {
        return new CommitTransactionRuleBuilder(this.controller);
    }

    public RollbackTransactionRuleBuilder rollbackTransaction() {
        return new RollbackTransactionRuleBuilder(this.controller);
    }

    private boolean propertyMatchesValue(String property, String value) {
        return Optional.ofNullable(property).orElse("").equalsIgnoreCase(value);
    }

    RuleBasedController getController() {
        return this.controller;
    }
}

