/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.db.server.builder;

import com.consol.citrus.db.driver.data.Table;
import com.consol.citrus.db.driver.dataset.DataSet;
import com.consol.citrus.db.driver.dataset.TableDataSetProducer;
import com.consol.citrus.db.driver.json.JsonDataSetProducer;
import com.consol.citrus.db.driver.xml.XmlDataSetProducer;
import com.consol.citrus.db.server.JdbcServerException;
import com.consol.citrus.db.server.builder.AbstractRuleBuilder;
import com.consol.citrus.db.server.controller.RuleBasedController;
import com.consol.citrus.db.server.rules.ExecuteRule;
import com.consol.citrus.db.server.rules.Mapping;
import com.consol.citrus.db.server.rules.Precondition;
import java.io.File;
import java.nio.file.Path;
import java.sql.SQLException;

public class ExecuteRuleBuilder
extends AbstractRuleBuilder<ExecuteRule, String, DataSet> {
    private final Precondition<String> precondition;

    ExecuteRuleBuilder(Precondition<String> precondition, RuleBasedController controller) {
        super(controller);
        this.precondition = precondition;
    }

    public ExecuteRule thenReturn(DataSet dataSet) {
        return this.createRule((Precondition)this.precondition, any -> dataSet);
    }

    public ExecuteRule thenReturn(File file) {
        return this.thenReturn(file.toPath());
    }

    public ExecuteRule thenReturn(Path path) {
        DataSet dataSet;
        try {
            dataSet = path.toString().endsWith(".json") ? new JsonDataSetProducer(path).produce() : (path.toString().endsWith(".xml") ? new XmlDataSetProducer(path).produce() : new TableDataSetProducer(new Table("empty")).produce());
        }
        catch (SQLException e) {
            throw new JdbcServerException(e);
        }
        return this.createRule((Precondition)this.precondition, any -> dataSet);
    }

    public ExecuteRule thenReturn() {
        return this.createRule((Precondition)this.precondition, any -> new DataSet());
    }

    @Override
    protected ExecuteRule createRule(Precondition<String> precondition, Mapping<String, DataSet> mapping) {
        ExecuteRule rule = new ExecuteRule(precondition, mapping);
        this.addRule(rule);
        return rule;
    }

    Precondition<String> getPrecondition() {
        return this.precondition;
    }
}

