/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.db.server.builder;

import com.consol.citrus.db.server.builder.CloseStatementRuleBuilder;
import com.consol.citrus.db.server.builder.CreatePreparedStatementRuleBuilder;
import com.consol.citrus.db.server.builder.CreateStatementRuleBuilder;
import com.consol.citrus.db.server.builder.ExecuteQueryRuleBuilder;
import com.consol.citrus.db.server.builder.ExecuteRuleBuilder;
import com.consol.citrus.db.server.builder.ExecuteUpdateRuleBuilder;
import com.consol.citrus.db.server.controller.RuleBasedController;
import com.consol.citrus.db.server.rules.Precondition;
import java.util.regex.Pattern;

public class StatementRuleBuilder {
    private RuleBasedController controller;

    StatementRuleBuilder(RuleBasedController controller) {
        this.controller = controller;
    }

    public CreateStatementRuleBuilder create() {
        return new CreateStatementRuleBuilder(this.controller);
    }

    public CreatePreparedStatementRuleBuilder prepare() {
        return this.prepare(Precondition.matchAll());
    }

    public CreatePreparedStatementRuleBuilder prepare(String sql) {
        return this.prepare((String stmt) -> stmt.equals(sql));
    }

    public CreatePreparedStatementRuleBuilder prepare(Precondition<String> matcher) {
        return new CreatePreparedStatementRuleBuilder(matcher, this.controller);
    }

    public ExecuteQueryRuleBuilder executeQuery(String sql) {
        return new ExecuteQueryRuleBuilder(stmt -> stmt.equals(sql), this.controller);
    }

    public ExecuteQueryRuleBuilder executeQuery(Pattern sql) {
        return new ExecuteQueryRuleBuilder(stmt -> sql.matcher((CharSequence)stmt).matches(), this.controller);
    }

    public ExecuteRuleBuilder execute(String sql) {
        return new ExecuteRuleBuilder(stmt -> stmt.equals(sql), this.controller);
    }

    public ExecuteRuleBuilder execute(Pattern sql) {
        return new ExecuteRuleBuilder(stmt -> sql.matcher((CharSequence)stmt).matches(), this.controller);
    }

    public ExecuteUpdateRuleBuilder executeUpdate(String sql) {
        return new ExecuteUpdateRuleBuilder(stmt -> stmt.equals(sql), this.controller);
    }

    public ExecuteUpdateRuleBuilder executeUpdate(Pattern sql) {
        return new ExecuteUpdateRuleBuilder(stmt -> sql.matcher((CharSequence)stmt).matches(), this.controller);
    }

    public CloseStatementRuleBuilder close() {
        return new CloseStatementRuleBuilder(this.controller);
    }

    RuleBasedController getController() {
        return this.controller;
    }
}

