/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.db.server.controller;

import com.consol.citrus.db.driver.dataset.DataSet;
import com.consol.citrus.db.server.JdbcServerException;
import com.consol.citrus.db.server.controller.JdbcController;
import java.sql.SQLException;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractJdbcController
implements JdbcController {
    private static Logger log = LoggerFactory.getLogger(JdbcController.class);
    private boolean transactionState;

    protected abstract DataSet handleQuery(String var1) throws JdbcServerException;

    protected abstract DataSet handleExecute(String var1) throws JdbcServerException;

    protected abstract int handleUpdate(String var1) throws JdbcServerException;

    @Override
    public void openConnection(Map<String, String> properties) throws JdbcServerException {
        log.info("OPEN CONNECTION with properties: " + properties.entrySet().stream().map(entry -> (String)entry.getKey() + "=" + (String)entry.getValue()).collect(Collectors.joining(" | ")));
    }

    @Override
    public void createStatement() throws JdbcServerException {
        log.info("CREATE STATEMENT");
    }

    @Override
    public void closeConnection() throws JdbcServerException {
        log.info("CLOSE CONNECTION");
    }

    @Override
    public void createPreparedStatement(String sql) throws JdbcServerException {
        log.info("CREATE PREPARED STATEMENT: " + sql);
    }

    @Override
    public DataSet executeQuery(String sql) throws JdbcServerException {
        log.info("EXECUTE QUERY: " + sql);
        DataSet dataSet = this.handleQuery(sql);
        try {
            if (log.isDebugEnabled()) {
                log.debug(String.format("RESULT SET with %s rows", dataSet.getRows().size()));
            }
        }
        catch (SQLException e) {
            throw new JdbcServerException("Failed to access dataSet", e);
        }
        log.info("QUERY EXECUTION SUCCESSFUL");
        return dataSet;
    }

    @Override
    public DataSet executeStatement(String sql) throws JdbcServerException {
        log.info("EXECUTE STATEMENT: " + sql);
        DataSet dataSet = this.handleExecute(sql);
        try {
            if (log.isDebugEnabled()) {
                log.debug(String.format("RESULT SET with %s rows", dataSet.getRows().size()));
            }
        }
        catch (SQLException e) {
            throw new JdbcServerException("Failed to access dataSet", e);
        }
        log.info("STATEMENT EXECUTION SUCCESSFUL");
        return dataSet;
    }

    @Override
    public int executeUpdate(String sql) throws JdbcServerException {
        log.info("EXECUTE UPDATE: " + sql);
        int rows = this.handleUpdate(sql);
        if (log.isDebugEnabled()) {
            log.debug(String.format("ROWS UPDATED %s", rows));
        }
        log.info("UPDATE EXECUTION SUCCESSFUL");
        return rows;
    }

    @Override
    public void closeStatement() throws JdbcServerException {
        log.info("CLOSE STATEMENT");
    }

    @Override
    public void setTransactionState(boolean transactionState) {
        log.info(String.format("RECEIVED TRANSACTION STATE CHANGE: %s", String.valueOf(transactionState)));
        this.transactionState = transactionState;
    }

    @Override
    public boolean getTransactionState() {
        log.info(String.format("GET TRANSACTION STATE: %s", String.valueOf(this.transactionState)));
        return this.transactionState;
    }

    @Override
    public void commitStatements() {
        log.info("COMMIT STATEMENTS");
    }

    @Override
    public void rollbackStatements() {
        log.info("ROLLBACK STATEMENTS");
    }

    @Override
    public void createCallableStatement(String sql) {
        log.info("CREATE CALLABLE STATEMENT: " + sql);
    }
}

