/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.db.server.controller;

import com.consol.citrus.db.driver.dataset.DataSet;
import com.consol.citrus.db.server.JdbcServerException;
import com.consol.citrus.db.server.controller.AbstractJdbcController;
import com.consol.citrus.db.server.controller.SimpleJdbcController;
import com.consol.citrus.db.server.rules.CloseConnectionRule;
import com.consol.citrus.db.server.rules.CloseStatementRule;
import com.consol.citrus.db.server.rules.CommitTransactionRule;
import com.consol.citrus.db.server.rules.CreateCallableStatementRule;
import com.consol.citrus.db.server.rules.CreatePreparedStatementRule;
import com.consol.citrus.db.server.rules.CreateStatementRule;
import com.consol.citrus.db.server.rules.ExecuteQueryRule;
import com.consol.citrus.db.server.rules.ExecuteRule;
import com.consol.citrus.db.server.rules.ExecuteUpdateRule;
import com.consol.citrus.db.server.rules.OpenConnectionRule;
import com.consol.citrus.db.server.rules.RollbackTransactionRule;
import com.consol.citrus.db.server.rules.Rule;
import com.consol.citrus.db.server.rules.StartTransactionRule;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class RuleBasedController
extends AbstractJdbcController {
    private final AbstractJdbcController delegateJdbcController;
    private List<OpenConnectionRule> openConnectionRules = new ArrayList<OpenConnectionRule>();
    private List<CloseConnectionRule> closeConnectionRules = new ArrayList<CloseConnectionRule>();
    private List<CreateStatementRule> createStatementRules = new ArrayList<CreateStatementRule>();
    private List<CreatePreparedStatementRule> createPreparedStatementRules = new ArrayList<CreatePreparedStatementRule>();
    private List<CloseStatementRule> closeStatementRules = new ArrayList<CloseStatementRule>();
    private List<ExecuteQueryRule> executeQueryRules = new ArrayList<ExecuteQueryRule>();
    private List<ExecuteRule> executeRules = new ArrayList<ExecuteRule>();
    private List<ExecuteUpdateRule> executeUpdateRules = new ArrayList<ExecuteUpdateRule>();
    private List<StartTransactionRule> startTransactionRule = new ArrayList<StartTransactionRule>();
    private List<CommitTransactionRule> commitTransactionRule = new ArrayList<CommitTransactionRule>();
    private List<RollbackTransactionRule> rollbackTransactionRule = new ArrayList<RollbackTransactionRule>();
    private List<CreateCallableStatementRule> createCallableStatementRules = new ArrayList<CreateCallableStatementRule>();

    public RuleBasedController() {
        this.delegateJdbcController = new SimpleJdbcController();
    }

    RuleBasedController(AbstractJdbcController delegateJdbcController) {
        this.delegateJdbcController = delegateJdbcController;
    }

    @Override
    protected DataSet handleQuery(String sql) throws JdbcServerException {
        return (DataSet)this.executeQueryRules.stream().filter(rule -> rule.matches(sql)).findFirst().orElse(new ExecuteQueryRule(this.delegateJdbcController::handleQuery)).applyOn(sql);
    }

    @Override
    protected DataSet handleExecute(String sql) throws JdbcServerException {
        return (DataSet)this.executeRules.stream().filter(rule -> rule.matches(sql)).findFirst().orElse(new ExecuteRule(this.delegateJdbcController::handleExecute)).applyOn(sql);
    }

    @Override
    protected int handleUpdate(String sql) throws JdbcServerException {
        return (Integer)this.executeUpdateRules.stream().filter(rule -> rule.matches(sql)).findFirst().orElse(new ExecuteUpdateRule(this.delegateJdbcController::handleUpdate)).applyOn(sql);
    }

    @Override
    public void openConnection(Map<String, String> properties) throws JdbcServerException {
        this.openConnectionRules.stream().filter(rule -> rule.matches(properties)).findFirst().orElse(new OpenConnectionRule()).applyOn(properties);
        this.delegateJdbcController.openConnection(properties);
    }

    @Override
    public void closeConnection() throws JdbcServerException {
        this.closeConnectionRules.stream().filter(rule -> rule.matches(null)).findFirst().orElse(new CloseConnectionRule()).applyOn(null);
        this.delegateJdbcController.closeConnection();
    }

    @Override
    public void createStatement() throws JdbcServerException {
        this.createStatementRules.stream().filter(rule -> rule.matches(null)).findFirst().orElse(new CreateStatementRule()).applyOn(null);
        this.delegateJdbcController.createStatement();
    }

    @Override
    public void createPreparedStatement(String sql) throws JdbcServerException {
        this.createPreparedStatementRules.stream().filter(rule -> rule.matches(sql)).findFirst().orElse(new CreatePreparedStatementRule()).applyOn(null);
        this.delegateJdbcController.createPreparedStatement(sql);
    }

    @Override
    public void closeStatement() throws JdbcServerException {
        this.closeStatementRules.stream().filter(rule -> rule.matches(null)).findFirst().orElse(new CloseStatementRule()).applyOn(null);
        this.delegateJdbcController.closeStatement();
    }

    @Override
    public void setTransactionState(boolean transactionState) {
        if (transactionState) {
            this.startTransactionRule.stream().filter(rule -> rule.matches(null)).findFirst().orElse(new StartTransactionRule()).applyOn(null);
        }
        this.delegateJdbcController.setTransactionState(transactionState);
    }

    @Override
    public void commitStatements() {
        this.commitTransactionRule.stream().filter(rule -> rule.matches(null)).findFirst().orElse(new CommitTransactionRule()).applyOn(null);
        this.delegateJdbcController.commitStatements();
    }

    @Override
    public void rollbackStatements() {
        this.rollbackTransactionRule.stream().filter(rule -> rule.matches(null)).findFirst().orElse(new RollbackTransactionRule()).applyOn(null);
        this.delegateJdbcController.rollbackStatements();
    }

    @Override
    public void createCallableStatement(String sql) {
        this.createCallableStatementRules.stream().filter(rule -> rule.matches(sql)).findFirst().orElse(new CreateCallableStatementRule()).applyOn(null);
        this.delegateJdbcController.createStatement();
    }

    public RuleBasedController add(Rule rule) {
        if (rule instanceof OpenConnectionRule) {
            this.add((OpenConnectionRule)rule);
        } else if (rule instanceof CloseConnectionRule) {
            this.add((CloseConnectionRule)rule);
        } else if (rule instanceof CreateStatementRule) {
            this.add((CreateStatementRule)rule);
        } else if (rule instanceof CreatePreparedStatementRule) {
            this.add((CreatePreparedStatementRule)rule);
        } else if (rule instanceof CloseStatementRule) {
            this.add((CloseStatementRule)rule);
        } else if (rule instanceof ExecuteQueryRule) {
            this.add((ExecuteQueryRule)rule);
        } else if (rule instanceof ExecuteRule) {
            this.add((ExecuteRule)rule);
        } else if (rule instanceof ExecuteUpdateRule) {
            this.add((ExecuteUpdateRule)rule);
        } else if (rule instanceof StartTransactionRule) {
            this.add((StartTransactionRule)rule);
        } else if (rule instanceof CommitTransactionRule) {
            this.add((CommitTransactionRule)rule);
        } else if (rule instanceof RollbackTransactionRule) {
            this.add((RollbackTransactionRule)rule);
        } else if (rule instanceof CreateCallableStatementRule) {
            this.add((CreateCallableStatementRule)rule);
        }
        return this;
    }

    private void add(OpenConnectionRule rule) {
        this.openConnectionRules.add(rule);
    }

    private void add(CloseConnectionRule rule) {
        this.closeConnectionRules.add(rule);
    }

    private void add(CreateStatementRule rule) {
        this.createStatementRules.add(rule);
    }

    private void add(CreatePreparedStatementRule rule) {
        this.createPreparedStatementRules.add(rule);
    }

    private void add(CloseStatementRule rule) {
        this.closeStatementRules.add(rule);
    }

    private void add(ExecuteQueryRule rule) {
        this.executeQueryRules.add(rule);
    }

    private void add(ExecuteRule rule) {
        this.executeRules.add(rule);
    }

    private void add(ExecuteUpdateRule rule) {
        this.executeUpdateRules.add(rule);
    }

    private void add(StartTransactionRule rule) {
        this.startTransactionRule.add(rule);
    }

    private void add(CommitTransactionRule rule) {
        this.commitTransactionRule.add(rule);
    }

    private void add(RollbackTransactionRule rule) {
        this.rollbackTransactionRule.add(rule);
    }

    private void add(CreateCallableStatementRule rule) {
        this.createCallableStatementRules.add(rule);
    }
}

